/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        AbstractContainerMenu menu = screen.getMenu();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.mayPickup((Player)player)) {
            return false;
        }
        ItemStack targetStack = clickedSlot.getItem().copy();
        if (targetStack.getCount() == 1) {
            this.slotClick(menu, clickedSlot, 0, ClickType.QUICK_MOVE);
            return true;
        }
        Slot fallbackSlot = null;
        for (Slot slot : menu.slots) {
            ItemStack stack = slot.getItem();
            if (!this.isValidTargetSlot(slot) || slot == clickedSlot || !slot.mayPlace(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.getCount() >= Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(stack))) continue;
            if (ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)stack)) {
                this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
                this.slotClick(menu, slot, 1, ClickType.PICKUP);
                this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
                return true;
            }
            if (slot.hasItem() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, fallbackSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        ItemStack targetStack = clickedSlot.getItem().copy();
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(clickedSlot);
        for (Slot slot : menu.slots) {
            ItemStack stack;
            if (slot == clickedSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot) || !ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)(stack = slot.getItem()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 0, ClickType.QUICK_MOVE);
        }
        return true;
    }

    @Override
    public boolean bulkTransferAll(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        if (!clickedSlot.hasItem() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.getMenu();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.container instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.slots) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.container instanceof Inventory) || !this.isValidTargetSlot(slot)) continue;
                if (slot.hasItem()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.isHotbarSlot((int)slot.getContainerSlot())) continue;
                emptySlots.add(slot);
            }
            NonNullList slots = menu.slots;
            for (int i = slots.size() - 1; i >= 0; --i) {
                Slot slot = (Slot)slots.get(i);
                if (!slot.mayPickup((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.bulkTransferPreferInventory(menu, player.getInventory(), emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else {
            for (Slot slot : menu.slots) {
                if (!slot.mayPickup((Player)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(menu, slot, 0, ClickType.QUICK_MOVE);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean bulkTransferPreferInventory(AbstractContainerMenu menu, Inventory inventory, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.getItem().copy();
        if (targetStack.isEmpty()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.getItem();
            if (!ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.getCount() < Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 0, ClickType.PICKUP);
            ItemStack mouseItem = menu.getCarried();
            if (!mouseItem.isEmpty()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.descendingIterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 0, ClickType.PICKUP);
            if (emptySlot.hasItem()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.getCarried()).isEmpty()) continue;
            return true;
        }
        ItemStack mouseItem = menu.getCarried();
        if (!mouseItem.isEmpty()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    @Override
    public void dragTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        this.slotClick(screen.getMenu(), clickedSlot, 0, ClickType.QUICK_MOVE);
    }

    protected void slotClick(AbstractContainerMenu menu, Slot slot, int mouseButton, ClickType clickType) {
        this.slotClick(menu, slot.index, mouseButton, clickType);
    }

    protected void slotClick(AbstractContainerMenu menu, int slotIndex, int mouseButton, ClickType clickType) {
        LocalPlayer player = Minecraft.getInstance().player;
        MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
        if (player != null && gameMode != null && (slotIndex >= 0 && slotIndex < menu.slots.size() || slotIndex == -999)) {
            gameMode.handleInventoryMouseClick(menu.containerId, slotIndex, mouseButton, clickType, (Player)player);
        }
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, Slot hoverSlot) {
        ItemStack targetStack = hoverSlot.getItem().copy();
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(hoverSlot);
        for (Slot slot : menu.slots) {
            ItemStack stack;
            if (slot == hoverSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, hoverSlot) || !ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)(stack = slot.getItem()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, ItemStack targetStack) {
        if (targetStack.isEmpty()) {
            return false;
        }
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        for (Slot slot : menu.slots) {
            ItemStack stack = slot.getItem();
            if (!ItemStack.isSameItemSameTags((ItemStack)targetStack, (ItemStack)stack) || !this.isValidTargetSlot(slot)) continue;
            transferSlots.add(slot);
        }
        this.slotClick(menu, -999, 0, ClickType.PICKUP);
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    protected boolean isValidTargetSlot(Slot slot) {
        return true;
    }
}

