/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;

    public static void initialize() {
        ModKeyMappings.initialize(BalmClient.getKeyMappings());
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, InventoryEssentialsClient::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Pre.class, InventoryEssentialsClient::onKeyPress);
    }

    private static InventoryControls getInventoryControls(AbstractContainerScreen<?> screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    private static boolean shouldHandleInput(AbstractContainerScreen<?> screen) {
        Slot hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
        if (hoverSlot instanceof ResultSlot) {
            return false;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor accessor = (CreativeModeInventoryScreenAccessor)screen;
            return hoverSlot == null || hoverSlot.container instanceof Inventory || hoverSlot.container != accessor.getCONTAINER();
        }
        return true;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (BalmClient.getKeyMappings().isActiveAndKeyDown(ModKeyMappings.keyDragTransfer)) {
            Screen screen = event.getScreen();
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
                if (hoverSlot == null || !InventoryEssentialsClient.shouldHandleInput(screen2) || !InventoryEssentialsClient.shouldHandleSlot(hoverSlot)) {
                    return;
                }
                if (hoverSlot.hasItem() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls(screen2);
                    controls.dragTransfer(screen2, hoverSlot);
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    private static boolean shouldHandleSlot(Slot slot) {
        return slot.container != null && slot.container.getContainerSize() != 0;
    }

    public static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), InputConstants.Type.MOUSE.getOrCreate(event.getButton()), event.getMouseX(), event.getMouseY())) {
            event.setCanceled(true);
        }
    }

    public static void onKeyPress(ScreenKeyEvent.Press.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), InputConstants.getKey((int)event.getKey(), (int)event.getScanCode()), 0.0, 0.0)) {
            event.setCanceled(true);
        }
    }

    public static boolean onInput(Screen screen, InputConstants.Key key, double mouseX, double mouseY) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            Slot hoverSlot = accessor.getHoveredSlot();
            if (!InventoryEssentialsClient.shouldHandleInput(containerScreen)) {
                return false;
            }
            InventoryControls controls = InventoryEssentialsClient.getInventoryControls(containerScreen);
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransfer, key)) {
                return hoverSlot != null && controls.bulkTransferByType(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keySingleTransfer, key)) {
                return hoverSlot != null && controls.singleTransfer(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransferAll, key)) {
                return hoverSlot != null && controls.bulkTransferAll(containerScreen, hoverSlot);
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyScreenBulkDrop, key)) {
                boolean clickedOutside = accessor.callHasClickedOutside(mouseX, mouseY, accessor.getLeftPos(), accessor.getTopPos(), key.getValue());
                return clickedOutside && controls.dropByType(containerScreen, containerScreen.getMenu().getCarried());
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkDrop, key)) {
                return hoverSlot != null && controls.dropByType(containerScreen, hoverSlot);
            }
        }
        return false;
    }
}

