/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.curios;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.curios.CuriosCompatClient;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat
implements ICompat {
    private Set<String> backpackCurioIdentifiers = new HashSet<String>();
    private long lastTagsRefresh = -1L;
    private static final int TAGS_REFRESH_COOLDOWN = 100;

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("curios", this::getCurioTags, (player, identifier) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, ICurioStacksHandler::getSlots, 0), (player, identifier, slot) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, sh -> sh.getStacks().getStackInSlot(slot), ItemStack.EMPTY), false, true, true, true);
    }

    private Set<String> getCurioTags(long gameTime) {
        if (this.lastTagsRefresh + 100L < gameTime) {
            this.lastTagsRefresh = gameTime;
            this.backpackCurioIdentifiers = new HashSet(CuriosApi.getItemStackSlots((ItemStack)ModItems.BACKPACK.get().getDefaultInstance()).keySet());
            this.backpackCurioIdentifiers.add(SlotTypePreset.CURIO.getIdentifier());
        }
        return this.backpackCurioIdentifiers;
    }

    public static <T> T getFromCuriosSlotStackHandler(LivingEntity livingEntity, String identifier, Function<ICurioStacksHandler, T> getFromHandler, T defaultValue) {
        return (T)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(h -> h.getStacksHandler(identifier).map(getFromHandler).orElse(defaultValue)).orElse(defaultValue);
    }

    public void setup() {
        if (FMLEnvironment.dist.isClient()) {
            CuriosCompatClient.registerRenderers();
        }
        this.addPlayerInventoryHandlers();
    }
}

