/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;

public class BackpackUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public BackpackUpgradeRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack upgradedBackpack = super.assemble(inv, registryAccess);
        this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.getTag())).ifPresent(tag -> upgradedBackpack.setTag(tag.copy()));
        IBackpackWrapper wrapper = BackpackWrapper.fromData(upgradedBackpack);
        BackpackItem backpackItem = (BackpackItem)upgradedBackpack.getItem();
        wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(CraftingContainer inv) {
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (!(slotStack.getItem() instanceof BackpackItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModItems.BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, BackpackUpgradeRecipe> {
        public Serializer() {
            super(BackpackUpgradeRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

