/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class InventoryInteractionPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "inventory_interaction");
    private final BlockPos pos;
    private final Direction face;

    public InventoryInteractionPacket(BlockPos pos, Direction face) {
        this.pos = pos;
        this.face = face;
    }

    public InventoryInteractionPacket(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (Direction)buffer.readEnum(Direction.class));
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            InventoryInteractionHelper.tryInventoryInteraction(this.pos, player.level(), backpack, this.face, player);
            player.swing(InteractionHand.MAIN_HAND, true);
            return true;
        });
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.face);
    }

    public ResourceLocation id() {
        return ID;
    }
}

