/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsPacket;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;

public class RequestBackpackInventoryContentsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "request_backpack_inventory_contents");
    private final UUID backpackUuid;

    public RequestBackpackInventoryContentsPacket(UUID backpackUuid) {
        this.backpackUuid = backpackUuid;
    }

    public RequestBackpackInventoryContentsPacket(FriendlyByteBuf buffer) {
        this(buffer.readUUID());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        Tag upgradeNbt;
        CompoundTag backpackContents = BackpackStorage.get().getOrCreateBackpackContents(this.backpackUuid);
        CompoundTag inventoryContents = new CompoundTag();
        Tag inventoryNbt = backpackContents.get("inventory");
        if (inventoryNbt != null) {
            inventoryContents.put("inventory", inventoryNbt);
        }
        if ((upgradeNbt = backpackContents.get("upgradeInventory")) != null) {
            inventoryContents.put("upgradeInventory", upgradeNbt);
        }
        PacketHelper.sendToPlayer((CustomPacketPayload)new BackpackContentsPacket(this.backpackUuid, inventoryContents), (Player)player);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.backpackUuid);
    }

    public ResourceLocation id() {
        return ID;
    }
}

