/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;

public class UpgradeTogglePacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedbackpacks", "upgrade_toggle");
    private final int upgradeSlot;

    public UpgradeTogglePacket(int upgradeSlot) {
        this.upgradeSlot = upgradeSlot;
    }

    public UpgradeTogglePacket(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            IUpgradeWrapper upgradeWrapper;
            Map slotWrappers = BackpackWrapper.fromData(backpack).getUpgradeHandler().getSlotWrappers();
            if (slotWrappers.containsKey(this.upgradeSlot) && (upgradeWrapper = (IUpgradeWrapper)slotWrappers.get(this.upgradeSlot)).canBeDisabled()) {
                upgradeWrapper.setEnabled(!upgradeWrapper.isEnabled());
                String translKey = upgradeWrapper.isEnabled() ? "gui.sophisticatedbackpacks.status.upgrade_switched_on" : "gui.sophisticatedbackpacks.status.upgrade_switched_off";
                player.displayClientMessage((Component)Component.translatable((String)translKey, (Object[])new Object[]{upgradeWrapper.getUpgradeStack().getHoverName()}), true);
            }
            return true;
        });
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.upgradeSlot);
    }

    public ResourceLocation id() {
        return ID;
    }
}

