/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.neoforged.fml.ModList;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.Matchers;

public class SwordRegistry {
    private static final Set<Item> SWORD_ITEMS = new HashSet<Item>();
    private static final Map<String, Set<Predicate<ItemStack>>> MOD_SWORD_MATCHERS = new HashMap<String, Set<Predicate<ItemStack>>>();
    private static final Set<Predicate<ItemStack>> SWORD_MATCHERS = new HashSet<Predicate<ItemStack>>();

    private SwordRegistry() {
    }

    public static boolean isSword(ItemStack stack) {
        if (SWORD_ITEMS.contains(stack.getItem())) {
            return true;
        }
        if (stack.getItem() instanceof SwordItem) {
            SWORD_ITEMS.add(stack.getItem());
            return true;
        }
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (registryName == BuiltInRegistries.ITEM.getDefaultKey()) {
            return false;
        }
        for (Predicate<ItemStack> swordMatcher : SWORD_MATCHERS) {
            if (!swordMatcher.test(stack)) continue;
            return true;
        }
        String modId = registryName.getNamespace();
        if (!MOD_SWORD_MATCHERS.containsKey(modId)) {
            return false;
        }
        Set<Predicate<ItemStack>> matchers = MOD_SWORD_MATCHERS.get(modId);
        for (Predicate<ItemStack> matcher : matchers) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static class SwordsLoader
    implements IRegistryDataLoader {
        @Override
        public String getName() {
            return "swords";
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray swords = json.getAsJsonArray("swords");
            for (JsonElement jsonElement : swords) {
                if (jsonElement.isJsonPrimitive()) {
                    this.parseSword(jsonElement.getAsString());
                    continue;
                }
                this.parseSwordMatcher(modId, jsonElement);
            }
        }

        private void parseSwordMatcher(@Nullable String modId, JsonElement jsonElement) {
            Matchers.getItemMatcher(jsonElement).ifPresent(swordMatcher -> {
                if (modId != null) {
                    MOD_SWORD_MATCHERS.computeIfAbsent(modId, m -> new HashSet()).add(swordMatcher);
                } else {
                    SWORD_MATCHERS.add((Predicate<ItemStack>)swordMatcher);
                }
            });
        }

        private void parseSword(String swordName) {
            BuiltInRegistries.ITEM.getOptional(new ResourceLocation(swordName)).ifPresentOrElse(SWORD_ITEMS::add, () -> {
                String modId = swordName.split(":")[0];
                if (!ModList.get().isLoaded(modId)) {
                    SophisticatedBackpacks.LOGGER.debug("Mod {} isn't loaded skipping load of sword {}", (Object)modId, (Object)swordName);
                } else {
                    SophisticatedBackpacks.LOGGER.warn("Mod {} is loaded and yet sword {} doesn't exist in registry, skipping its load", (Object)modId, (Object)swordName);
                }
            });
        }

        @Override
        public void clear() {
            SWORD_ITEMS.clear();
            SWORD_MATCHERS.clear();
            MOD_SWORD_MATCHERS.clear();
        }
    }
}

