/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.CompoundTagByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.IdMapByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ItemStackByteCodec;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public final class ExtraByteCodecs {
    public static final ByteCodec<ResourceLocation> RESOURCE_LOCATION = ByteCodec.STRING.map(ResourceLocation::new, ResourceLocation::toString);
    public static final ByteCodec<ResourceKey<Level>> DIMENSION = ExtraByteCodecs.resourceKey(Registries.DIMENSION);
    public static final ByteCodec<BlockPos> BLOCK_POS = ByteCodec.LONG.map(BlockPos::of, BlockPos::asLong);
    public static final ByteCodec<ChunkPos> CHUNK_POS = ByteCodec.LONG.map(ChunkPos::new, ChunkPos::toLong);
    public static final ByteCodec<SectionPos> SECTION_POS = ByteCodec.LONG.map(SectionPos::of, SectionPos::asLong);
    public static final ByteCodec<GlobalPos> GLOBAL_POS = ObjectByteCodec.create((ObjectEntryByteCodec)DIMENSION.fieldOf(GlobalPos::dimension), (ObjectEntryByteCodec)BLOCK_POS.fieldOf(GlobalPos::pos), GlobalPos::of);
    public static final ByteCodec<Vector3f> VECTOR_3F = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::x), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::y), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::z), Vector3f::new);
    public static final ByteCodec<CompoundTag> NULLABLE_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(value -> value.orElse(null), Optional::ofNullable);
    public static final ByteCodec<CompoundTag> NONNULL_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(Optional::orElseThrow, Optional::of);
    public static final ByteCodec<Optional<CompoundTag>> COMPOUND_TAG = CompoundTagByteCodec.INSTANCE;
    public static final ByteCodec<Component> COMPONENT = ByteCodec.STRING_COMPONENT.map(Component.Serializer::fromJson, Component.Serializer::toJson);
    public static final ByteCodec<Item> ITEM = ExtraByteCodecs.registry(BuiltInRegistries.ITEM);
    public static final ByteCodec<ItemStack> ITEM_STACK = ItemStackByteCodec.CODEC;
    public static final ByteCodec<Ingredient> INGREDIENT = ByteCodec.passthrough((buf, ingredient) -> ingredient.toNetwork(ExtraByteCodecs.toFriendly(buf)), buf -> Ingredient.fromNetwork((FriendlyByteBuf)ExtraByteCodecs.toFriendly(buf)));

    private ExtraByteCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static <T, R extends Registry<T>> ByteCodec<ResourceKey<T>> resourceKey(ResourceKey<R> registry) {
        return RESOURCE_LOCATION.map(id -> ResourceKey.create((ResourceKey)registry, (ResourceLocation)id), ResourceKey::location);
    }

    public static <T> ByteCodec<T> registry(IdMap<T> map) {
        return new IdMapByteCodec<T>(map);
    }

    public static FriendlyByteBuf toFriendly(ByteBuf buffer) {
        FriendlyByteBuf friendlyByteBuf;
        return buffer instanceof FriendlyByteBuf ? (friendlyByteBuf = (FriendlyByteBuf)buffer) : new FriendlyByteBuf(buffer);
    }
}

