/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.serialization.Codec;
import java.math.BigDecimal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record NbtPredicate(CompoundTag tag) {
    public static final NbtPredicate ANY = new NbtPredicate(null);
    public static final Codec<NbtPredicate> CODEC = CompoundTag.CODEC.xmap(NbtPredicate::new, NbtPredicate::tag);

    public boolean matches(ItemStack pStack) {
        if (this == ANY || NbtPredicate.isEmpty((Tag)this.tag)) {
            return true;
        }
        return this.matches((Tag)pStack.getTag());
    }

    public boolean matches(Entity pEntity) {
        if (this == ANY || NbtPredicate.isEmpty((Tag)this.tag)) {
            return true;
        }
        return this.matches((Tag)NbtPredicate.getEntityTagToCompare(pEntity));
    }

    public boolean matches(@Nullable Tag tag) {
        return this.matches(tag, true);
    }

    public boolean matches(@Nullable Tag tag, boolean strict) {
        if (this == ANY) {
            return true;
        }
        boolean empty = NbtPredicate.isEmpty((Tag)this.tag);
        if (NbtPredicate.isEmpty(tag)) {
            return empty;
        }
        return strict ? NbtUtils.compareNbt((Tag)this.tag, (Tag)tag, (boolean)true) : NbtPredicate.compareNbt((Tag)this.tag, tag);
    }

    public static boolean compareNbt(@Nullable Tag tag, @Nullable Tag tag2) {
        if (tag == tag2) {
            return true;
        }
        if (tag == null || tag2 == null) {
            return true;
        }
        if (tag instanceof NumericTag) {
            NumericTag num1 = (NumericTag)tag;
            if (tag2 instanceof NumericTag) {
                BigDecimal bigDecimal2;
                NumericTag num2 = (NumericTag)tag2;
                BigDecimal bigDecimal = new BigDecimal(num1.getAsNumber().toString());
                return bigDecimal.compareTo(bigDecimal2 = new BigDecimal(num2.getAsNumber().toString())) == 0;
            }
        }
        if (!tag.getClass().equals(tag2.getClass())) {
            return false;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            CompoundTag compound2 = (CompoundTag)tag2;
            for (String key : compound.getAllKeys()) {
                if (NbtPredicate.compareNbt(compound.get(key), compound2.get(key))) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            ListTag list2 = (ListTag)tag2;
            if (list.isEmpty()) {
                return list2.isEmpty();
            }
            for (Tag entry : list) {
                boolean oneMatches = false;
                for (Tag value : list2) {
                    if (!NbtPredicate.compareNbt(entry, value)) continue;
                    oneMatches = true;
                    break;
                }
                if (oneMatches) continue;
                return false;
            }
            return true;
        }
        return tag.equals(tag2);
    }

    public static boolean isEmpty(Tag tag) {
        ListTag list;
        CompoundTag compoundTag;
        return tag == null || tag instanceof CompoundTag && (compoundTag = (CompoundTag)tag).isEmpty() || tag instanceof ListTag && (list = (ListTag)tag).isEmpty();
    }

    private static CompoundTag getEntityTagToCompare(Entity entity) {
        Player player;
        ItemStack itemstack;
        CompoundTag compoundtag = entity.saveWithoutId(new CompoundTag());
        if (entity instanceof Player && !(itemstack = (player = (Player)entity).getInventory().getSelected()).isEmpty()) {
            compoundtag.put("SelectedItem", (Tag)itemstack.save(new CompoundTag()));
        }
        return compoundtag;
    }
}

