/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record RestrictedItemPredicate(Item item, Optional<NbtPredicate> nbt, MinMaxBounds.Ints durability, MinMaxBounds.Ints count) {
    public static final Codec<RestrictedItemPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(RestrictedItemPredicate::item), (App)ExtraCodecs.strictOptionalField((Codec)NbtPredicate.CODEC, (String)"nbt").forGetter(RestrictedItemPredicate::nbt), (App)MinMaxBounds.Ints.CODEC.fieldOf("durability").orElse((Object)MinMaxBounds.Ints.ANY).forGetter(RestrictedItemPredicate::durability), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").orElse((Object)MinMaxBounds.Ints.ANY).forGetter(RestrictedItemPredicate::count)).apply((Applicative)instance, RestrictedItemPredicate::new));

    public Optional<CompoundTag> getTag() {
        return this.nbt().map(NbtPredicate::tag);
    }

    public boolean matches(ItemStack stack) {
        if (this.item == null) {
            return false;
        }
        if (stack.is(this.item)) {
            return false;
        }
        if (!this.durability.isAny() && !stack.isDamageableItem()) {
            return false;
        }
        if (!this.durability.matches(stack.getMaxDamage() - stack.getDamageValue())) {
            return false;
        }
        if (!this.count.matches(stack.getCount())) {
            return false;
        }
        return this.nbt.isEmpty() || this.nbt.get().matches(stack);
    }
}

