/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.item.tabs.neoforge;

import com.teamresourceful.resourcefullib.common.item.tabs.ResourcefulCreativeTab;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ResourcefulCreativeTabImpl {
    private static final Map<String, DeferredRegister<CreativeModeTab>> CREATIVE_TABS = new ConcurrentHashMap<String, DeferredRegister<CreativeModeTab>>();

    public static Supplier<CreativeModeTab> create(ResourcefulCreativeTab tab) {
        return Entry.of(tab);
    }

    private static DeferredHolder<CreativeModeTab, CreativeModeTab> register(ResourceLocation id, Supplier<CreativeModeTab> tab) {
        DeferredRegister register = CREATIVE_TABS.computeIfAbsent(id.getNamespace(), namespace -> {
            DeferredRegister registry = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)namespace);
            registry.register(FMLJavaModLoadingContext.get().getModEventBus());
            return registry;
        });
        return register.register(id.getPath(), tab);
    }

    private record Entry(DeferredHolder<CreativeModeTab, CreativeModeTab> builtTab) implements Supplier<CreativeModeTab>
    {
        public static Entry of(ResourcefulCreativeTab tab) {
            CreativeModeTab.Builder creativeTab = CreativeModeTab.builder().icon(() -> tab.icon.get()).title((Component)Component.translatable((String)("itemGroup." + tab.id.getNamespace() + "." + tab.id.getPath())));
            if (tab.hideScrollBar) {
                creativeTab.noScrollBar();
            }
            if (tab.hideTitle) {
                creativeTab.hideTitle();
            }
            creativeTab.displayItems((params, output) -> {
                tab.registries.forEach(registry -> registry.boundStream().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0)));
                tab.stacks.stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                tab.contents.stream().flatMap(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            });
            return new Entry(ResourcefulCreativeTabImpl.register(tab.id, () -> ((CreativeModeTab.Builder)creativeTab).build()));
        }

        @Override
        public CreativeModeTab get() {
            return (CreativeModeTab)this.builtTab.get();
        }
    }
}

