/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.list;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamresourceful.resourcefullib.common.nbt.validators.TagValidationType;
import com.teamresourceful.resourcefullib.common.nbt.validators.Validator;
import com.teamresourceful.resourcefullib.common.nbt.validators.list.ListValidator;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;

public record ExactListValidator(List<Validator<?>> validators) implements ListValidator
{
    public static final String ID = "list:exact";
    public static final Codec<ExactListValidator> CODEC = ExtraCodecs.validate((Codec)Validator.CODEC.listOf(), validators -> {
        TagValidationType type = null;
        for (Validator validator : validators) {
            if (type == null) {
                type = validator.type();
                continue;
            }
            if (type == validator.type()) continue;
            return DataResult.error(() -> "All validators must be of the same type.");
        }
        return DataResult.success((Object)validators);
    }).xmap(ExactListValidator::new, ExactListValidator::validators);

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(CollectionTag<?> tag) {
        if (tag.isEmpty()) {
            return false;
        }
        if (tag.size() != this.validators.size()) {
            return false;
        }
        for (int i = 0; i < tag.size(); ++i) {
            if (this.validators.get(i).testAndValidate((Tag)tag.get(i))) continue;
            return false;
        }
        return true;
    }
}

