/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class AddTemplatePoolElementsModifier
extends Modifier {
    public static final Codec<AddTemplatePoolElementsModifier> CODEC = RecordCodecBuilder.create(instance -> AddTemplatePoolElementsModifier.addModifierFields(instance).and(instance.group((App)ResourceLocation.CODEC.fieldOf("template_pool").forGetter(AddTemplatePoolElementsModifier::rawTemplatePoolLocation), (App)Codec.mapPair((MapCodec)StructurePoolElement.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(AddTemplatePoolElementsModifier::elements), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.TEMPLATE_POOL))).apply((Applicative)instance, AddTemplatePoolElementsModifier::new));
    private final ResourceKey<StructureTemplatePool> EMPTY_TEMPLATE_POOL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("lithostitched", "empty"));
    private final ResourceLocation rawTemplatePoolLocation;
    private final Holder<StructureTemplatePool> templatePool;
    private final List<Pair<StructurePoolElement, Integer>> elements;

    public AddTemplatePoolElementsModifier(ModifierPredicate predicate, ResourceLocation rawTemplatePoolLocation, List<Pair<StructurePoolElement, Integer>> elements, HolderGetter<StructureTemplatePool> getter) {
        super(predicate, Modifier.ModifierPhase.ADD);
        this.rawTemplatePoolLocation = rawTemplatePoolLocation;
        Optional templatePoolEntry = getter.get(predicate.test() ? ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)rawTemplatePoolLocation) : this.EMPTY_TEMPLATE_POOL);
        this.templatePool = (Holder)templatePoolEntry.get();
        this.elements = elements;
    }

    public Holder<StructureTemplatePool> templatePool() {
        return this.templatePool;
    }

    public ResourceLocation rawTemplatePoolLocation() {
        return this.rawTemplatePoolLocation;
    }

    public List<Pair<StructurePoolElement, Integer>> elements() {
        return this.elements;
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }

    @Override
    public void applyModifier() {
        if (this.templatePool.is(this.EMPTY_TEMPLATE_POOL)) {
            return;
        }
        StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)this.templatePool().value();
        StructurePoolAccess lithostitchedPoolAccessor = (StructurePoolAccess)this.templatePool().value();
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
        rawTemplates.addAll(this.elements());
        poolAccessor.setRawTemplates(rawTemplates);
        ObjectArrayList vanillaTemplates = new ObjectArrayList(poolAccessor.getVanillaTemplates());
        ShufflingList<StructurePoolElement> lithostitchedTemplates = lithostitchedPoolAccessor.getLithostitchedTemplates();
        for (Pair<StructurePoolElement, Integer> pair : this.elements()) {
            lithostitchedTemplates.add((Object)((StructurePoolElement)pair.getFirst()), ((Integer)pair.getSecond()).intValue());
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                vanillaTemplates.add((Object)((StructurePoolElement)pair.getFirst()));
            }
        }
        poolAccessor.setVanillaTemplates((ObjectArrayList<StructurePoolElement>)vanillaTemplates);
        lithostitchedPoolAccessor.setLithostitchedTemplates(lithostitchedTemplates);
    }
}

