/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.PlacedFeatureAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class RedirectFeatureModifier
extends Modifier {
    public static final Codec<RedirectFeatureModifier> CODEC = RecordCodecBuilder.create(instance -> RedirectFeatureModifier.addModifierFields(instance).and(instance.group((App)ResourceLocation.CODEC.fieldOf("placed_feature").forGetter(RedirectFeatureModifier::rawPlacedFeatureLocation), (App)ConfiguredFeature.CODEC.fieldOf("redirect_to").forGetter(RedirectFeatureModifier::redirectTo), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.PLACED_FEATURE))).apply((Applicative)instance, RedirectFeatureModifier::new));
    private final ResourceKey<PlacedFeature> EMPTY_PLACED_FEATURE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("lithostitched", "empty"));
    private final ResourceLocation rawPlacedFeatureLocation;
    private final Holder<PlacedFeature> placedFeature;
    private final Holder<ConfiguredFeature<?, ?>> redirectTo;

    public RedirectFeatureModifier(ModifierPredicate predicate, ResourceLocation rawPlacedFeatureLocation, Holder<ConfiguredFeature<?, ?>> redirectTo, HolderGetter<PlacedFeature> getter) {
        super(predicate, Modifier.ModifierPhase.MODIFY);
        this.rawPlacedFeatureLocation = rawPlacedFeatureLocation;
        Optional placedFeatureEntry = getter.get(predicate.test() ? ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)rawPlacedFeatureLocation) : this.EMPTY_PLACED_FEATURE);
        this.placedFeature = (Holder)placedFeatureEntry.get();
        this.redirectTo = redirectTo;
    }

    public ResourceLocation rawPlacedFeatureLocation() {
        return this.rawPlacedFeatureLocation;
    }

    public Holder<PlacedFeature> placedFeature() {
        return this.placedFeature;
    }

    public Holder<ConfiguredFeature<?, ?>> redirectTo() {
        return this.redirectTo;
    }

    @Override
    public void applyModifier() {
        if (this.placedFeature.is(this.EMPTY_PLACED_FEATURE)) {
            return;
        }
        ((PlacedFeatureAccessor)this.placedFeature().value()).setFeature(this.redirectTo());
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

