/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class RemoveStructuresFromStructureSetModifier
extends Modifier {
    public static final Codec<RemoveStructuresFromStructureSetModifier> CODEC = RecordCodecBuilder.create(instance -> RemoveStructuresFromStructureSetModifier.addModifierFields(instance).and(instance.group((App)ResourceLocation.CODEC.fieldOf("structure_set").forGetter(RemoveStructuresFromStructureSetModifier::rawStructureSetLocation), (App)Structure.CODEC.listOf().fieldOf("structures").forGetter(RemoveStructuresFromStructureSetModifier::entries), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.STRUCTURE_SET))).apply((Applicative)instance, RemoveStructuresFromStructureSetModifier::new));
    private final ResourceKey<StructureSet> EMPTY_STRUCTURE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)new ResourceLocation("lithostitched", "empty"));
    private final ResourceLocation rawStructureSetLocation;
    private final Holder<StructureSet> structureSet;
    private final List<Holder<Structure>> entries;

    public RemoveStructuresFromStructureSetModifier(ModifierPredicate predicate, ResourceLocation rawStructureSetLocation, List<Holder<Structure>> entries, HolderGetter<StructureSet> getter) {
        super(predicate, Modifier.ModifierPhase.REMOVE);
        this.rawStructureSetLocation = rawStructureSetLocation;
        Optional structureSetEntry = getter.get(predicate.test() ? ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)rawStructureSetLocation) : this.EMPTY_STRUCTURE_SET);
        this.structureSet = (Holder)structureSetEntry.get();
        this.entries = entries;
    }

    public ResourceLocation rawStructureSetLocation() {
        return this.rawStructureSetLocation;
    }

    public Holder<StructureSet> structureSet() {
        return this.structureSet;
    }

    public List<Holder<Structure>> entries() {
        return this.entries;
    }

    @Override
    public void applyModifier() {
        if (this.structureSet.is(this.EMPTY_STRUCTURE_SET)) {
            return;
        }
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)this.structureSet().value();
        ArrayList structureSelectionEntries = new ArrayList(((StructureSet)this.structureSet().value()).structures());
        structureSetAccessor.setStructures(structureSelectionEntries.stream().filter(setEntry -> !this.entries.contains(setEntry.structure())).collect(Collectors.toList()));
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

