/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class ReferenceStructureProcessor
extends StructureProcessor {
    public static final Codec<ReferenceStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.PROCESSOR_LIST, (Codec)StructureProcessorType.DIRECT_CODEC).fieldOf("processor_lists").forGetter(ReferenceStructureProcessor::processorLists)).apply((Applicative)instance, ReferenceStructureProcessor::new));
    public static final StructureProcessorType<ReferenceStructureProcessor> REFERENCE_TYPE = () -> CODEC;
    private final HolderSet<StructureProcessorList> processorLists;

    public ReferenceStructureProcessor(HolderSet<StructureProcessorList> processorLists) {
        this.processorLists = processorLists;
    }

    public HolderSet<StructureProcessorList> processorLists() {
        return this.processorLists;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlaceSettings) {
        for (Holder processorList : this.processorLists) {
            for (StructureProcessor processor : ((StructureProcessorList)processorList.value()).list()) {
                StructureTemplate.StructureBlockInfo candidateBlockInfo = processor.processBlock(levelReader, blockPos, blockPos2, structureBlockInfo, currentBlockInfo, structurePlaceSettings);
                if (candidateBlockInfo == currentBlockInfo) continue;
                return candidateBlockInfo;
            }
        }
        return currentBlockInfo;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return REFERENCE_TYPE;
    }
}

