/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.worldgen.poolelement.ExclusivePoolElement;
import dev.worldgen.lithostitched.worldgen.poolelement.GuaranteedPoolElement;
import dev.worldgen.lithostitched.worldgen.poolelement.LimitedPoolElement;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<Structure.GenerationStub> generate(Structure.GenerationContext context, Holder<StructureTemplatePool> structurePool, Optional<ResourceLocation> id, int size, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        BlockPos blockPos;
        RegistryAccess dynamicRegistryManager = context.registryAccess();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        StructureTemplateManager structureTemplateManager = context.structureTemplateManager();
        LevelHeightAccessor heightLimitView = context.heightAccessor();
        WorldgenRandom chunkRandom = context.random();
        Registry registry = dynamicRegistryManager.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation blockRotation = Rotation.getRandom((RandomSource)chunkRandom);
        StructureTemplatePool structurePool2 = (StructureTemplatePool)structurePool.value();
        StructurePoolElement structurePoolElement = structurePool2.getRandomTemplate((RandomSource)chunkRandom);
        if (structurePoolElement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            ResourceLocation identifier = id.get();
            Optional<BlockPos> optional = AlternateJigsawGenerator.findStartingJigsawPos(structurePoolElement, identifier, pos, blockRotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.unwrapKey().map(key -> key.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        BlockPos vec3i = blockPos.subtract((Vec3i)pos);
        BlockPos blockPos2 = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.getGroundLevelDelta(), blockRotation, structurePoolElement.getBoundingBox(structureTemplateManager, blockPos2, blockRotation));
        BoundingBox blockBox = poolStructurePiece.getBoundingBox();
        int i = (blockBox.maxX() + blockBox.minX()) / 2;
        int j = (blockBox.maxZ() + blockBox.minZ()) / 2;
        int k = projectStartToHeightmap.map(type -> pos.getY() + chunkGenerator.getFirstFreeHeight(i, j, type, heightLimitView, context.randomState())).orElseGet(() -> ((BlockPos)blockPos2).getY());
        int l = blockBox.minY() + poolStructurePiece.getGroundLevelDelta();
        poolStructurePiece.move(0, k - l, 0);
        int m = k + vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                AABB box = new AABB((double)(i - maxDistanceFromCenter), (double)(m - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(m + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelShape = Shapes.join((VoxelShape)Shapes.create((AABB)box), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)blockBox)), (BooleanOp)BooleanOp.ONLY_FIRST);
                AlternateJigsawGenerator.generate(context.randomState(), size, useExpansionHack, chunkGenerator, structureTemplateManager, heightLimitView, (RandomSource)chunkRandom, (Registry<StructureTemplatePool>)registry, poolStructurePiece, list, voxelShape);
                Objects.requireNonNull(collector);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)collector).addPiece(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> findStartingJigsawPos(StructurePoolElement pool, ResourceLocation id, BlockPos pos, Rotation rotation, StructureTemplateManager structureManager, WorldgenRandom random) {
        List list = pool.getShuffledJigsawBlocks(structureManager, pos, rotation, (RandomSource)random);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
            ResourceLocation identifier;
            if (structureBlockInfo.nbt() == null || !id.equals((Object)(identifier = ResourceLocation.tryParse((String)structureBlockInfo.nbt().getString("name"))))) continue;
            optional = Optional.of(structureBlockInfo.pos());
            break;
        }
        return optional;
    }

    private static void generate(RandomState noiseConfig, int maxSize, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, Registry<StructureTemplatePool> structurePoolRegistry, PoolElementStructurePiece firstPiece, List<PoolElementStructurePiece> pieces, VoxelShape pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<VoxelShape>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, useExpansionHack, heightLimitView, noiseConfig);
        }
    }

    static final class StructurePoolGenerator {
        private final Registry<StructureTemplatePool> registry;
        private final int maxSize;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> piecesToPlace;
        private final RandomSource random;
        private final Map<ExclusivePoolElement, Integer> elementsToCounts;
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(Registry<StructureTemplatePool> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> children, RandomSource random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
            this.elementsToCounts = new HashMap<ExclusivePoolElement, Integer>();
        }

        void generatePiece(PoolElementStructurePiece parentPiece, MutableObject<VoxelShape> voxelShape, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig) {
            StructurePoolElement anchorElement = parentPiece.getElement();
            MutableObject<VoxelShape> parentShape = new MutableObject<VoxelShape>();
            for (StructureTemplate.StructureBlockInfo anchorJigsawInfo : anchorElement.getShuffledJigsawBlocks(this.structureTemplateManager, parentPiece.getPosition(), parentPiece.getRotation(), this.random)) {
                MutableObject<VoxelShape> childShape;
                BoundingBox parentBoundingBox = parentPiece.getBoundingBox();
                BlockPos candidateConnectorPos = anchorJigsawInfo.pos().relative(JigsawBlock.getFrontFacing((BlockState)anchorJigsawInfo.state()));
                int k = -1;
                Holder<StructureTemplatePool> poolEntry = this.getStructurePoolEntry(StructurePoolGenerator.getPoolKey(anchorJigsawInfo));
                if (poolEntry == null) {
                    return;
                }
                boolean connectorInParentBoundingBox = parentBoundingBox.isInside((Vec3i)candidateConnectorPos);
                if (connectorInParentBoundingBox) {
                    childShape = parentShape;
                    if (parentShape.getValue() == null) {
                        parentShape.setValue((Object)Shapes.create((AABB)AABB.of((BoundingBox)parentBoundingBox)));
                    }
                } else {
                    childShape = voxelShape;
                }
                this.findAndTestChildCandidates(poolEntry, this.collectChildCandidateList(StructurePoolGenerator.getPoolKey(anchorJigsawInfo), depth, true), parentPiece, anchorJigsawInfo, childShape, k, depth, useExpansionHack, world, noiseConfig);
            }
        }

        private void findAndTestChildCandidates(Holder<StructureTemplatePool> fallbackEntry, List<StructurePoolElement> childCandidates, PoolElementStructurePiece parentPiece, StructureTemplate.StructureBlockInfo anchorJigsawInfo, MutableObject<VoxelShape> mutableObject2, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig) {
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig);
            if (!foundChild) {
                this.findAndTestChildCandidates((Holder<StructureTemplatePool>)((StructureTemplatePool)fallbackEntry.value()).getFallback(), this.collectChildCandidateList((ResourceKey<StructureTemplatePool>)((StructureTemplatePool)fallbackEntry.value()).getFallback().unwrapKey().orElse(Pools.EMPTY), depth, false), parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig);
            }
        }

        private List<StructurePoolElement> collectChildCandidateList(ResourceKey<StructureTemplatePool> poolKey, int depth, boolean firstIteration) {
            Holder pool = (Holder)this.registry.getHolder(poolKey).orElseThrow();
            if (depth == this.maxSize && firstIteration) {
                pool = ((StructureTemplatePool)pool.value()).getFallback();
            }
            if (pool.unwrapKey().isPresent() && pool.unwrapKey().get() == Pools.EMPTY) {
                return List.of();
            }
            if (pool == ((StructureTemplatePool)pool.value()).getFallback()) {
                LithostitchedCommon.LOGGER.warn("Template pool fallback references itself: {}", (Object)pool.unwrapKey().map(ResourceKey::toString).orElse("<unregistered>"));
                return List.of();
            }
            ShufflingList structurePoolElementsList = ((StructurePoolAccess)pool.value()).getLithostitchedTemplates().shuffle();
            ArrayList<StructurePoolElement> elements = new ArrayList<StructurePoolElement>(structurePoolElementsList.stream().filter(element -> {
                GuaranteedPoolElement guaranteedElement;
                return element instanceof GuaranteedPoolElement && (guaranteedElement = (GuaranteedPoolElement)((Object)element)).minDepth() <= depth;
            }).toList());
            elements.addAll(structurePoolElementsList.stream().filter(element -> !elements.contains(element)).toList());
            return elements.stream().toList();
        }

        private boolean findValidChildPiece(List<StructurePoolElement> childCandidates, PoolElementStructurePiece parentPiece, StructureTemplate.StructureBlockInfo anchorJigsawInfo, MutableObject<VoxelShape> mutableObject2, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig) {
            BlockPos anchorPos = anchorJigsawInfo.pos();
            BlockPos candidateConnectorPos = anchorPos.relative(JigsawBlock.getFrontFacing((BlockState)anchorJigsawInfo.state()));
            int parentMinY = parentPiece.getBoundingBox().minY();
            int anchorDistanceToFloor = anchorPos.getY() - parentMinY;
            StructureTemplatePool.Projection parentProjection = parentPiece.getElement().getProjection();
            boolean parentRigid = parentProjection == StructureTemplatePool.Projection.RIGID;
            for (StructurePoolElement candidateElement : childCandidates.stream().distinct().toList()) {
                StructurePoolElement processedCandidateElement;
                if (candidateElement == EmptyPoolElement.INSTANCE) {
                    return true;
                }
                if (candidateElement instanceof ExclusivePoolElement) {
                    ExclusivePoolElement exclusiveElement = (ExclusivePoolElement)candidateElement;
                    if (exclusiveElement instanceof LimitedPoolElement) {
                        LimitedPoolElement limitedElement = (LimitedPoolElement)exclusiveElement;
                        if (!this.elementsToCounts.containsKey((Object)limitedElement)) {
                            this.elementsToCounts.put(limitedElement, limitedElement.limit());
                        }
                        if (this.elementsToCounts.get((Object)limitedElement) < 1) {
                            continue;
                        }
                    } else if (exclusiveElement instanceof GuaranteedPoolElement) {
                        GuaranteedPoolElement guaranteedElement = (GuaranteedPoolElement)exclusiveElement;
                        if (!this.elementsToCounts.containsKey((Object)guaranteedElement)) {
                            this.elementsToCounts.put(guaranteedElement, 0);
                        }
                        if (this.elementsToCounts.get((Object)guaranteedElement) >= guaranteedElement.count()) continue;
                    }
                    processedCandidateElement = exclusiveElement.delegate();
                } else {
                    processedCandidateElement = candidateElement;
                }
                for (Rotation rotation : Rotation.getShuffled((RandomSource)this.random)) {
                    List connectorJigsaws = processedCandidateElement.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, rotation, this.random);
                    BoundingBox connectorBoundingBox = processedCandidateElement.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, rotation);
                    int l = useExpansionHack && connectorBoundingBox.getYSpan() <= 16 ? connectorJigsaws.stream().mapToInt(blockInfo -> {
                        if (!connectorBoundingBox.isInside((Vec3i)blockInfo.pos().relative(JigsawBlock.getFrontFacing((BlockState)blockInfo.state())))) {
                            return 0;
                        }
                        ResourceKey<StructureTemplatePool> registryKey2 = StructurePoolGenerator.getPoolKey(blockInfo);
                        Optional optional1 = this.registry.getHolder(registryKey2);
                        Optional<Holder> optional2 = optional1.map(entry -> ((StructureTemplatePool)entry.value()).getFallback());
                        int i2 = optional1.map(entry -> ((StructureTemplatePool)entry.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((StructureTemplatePool)entry.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!JigsawBlock.canAttach((StructureTemplate.StructureBlockInfo)anchorJigsawInfo, (StructureTemplate.StructureBlockInfo)connectorJigsawInfo)) continue;
                        BlockPos connectorPos = connectorJigsawInfo.pos();
                        BlockPos blockPos5 = candidateConnectorPos.subtract((Vec3i)connectorPos);
                        BoundingBox blockBox3 = processedCandidateElement.getBoundingBox(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.minY();
                        StructureTemplatePool.Projection connectorProjection = processedCandidateElement.getProjection();
                        boolean connectorProjectionRigid = connectorProjection == StructureTemplatePool.Projection.RIGID;
                        int connectorY = connectorPos.getY();
                        int o = anchorDistanceToFloor - connectorY + JigsawBlock.getFrontFacing((BlockState)anchorJigsawInfo.state()).getStepY();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(anchorPos.getX(), anchorPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        BoundingBox blockBox4 = blockBox3.moved(0, q, 0);
                        BlockPos blockPos6 = blockPos5.offset(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.maxY() - blockBox4.minY());
                            blockBox4.encapsulate(new BlockPos(blockBox4.minX(), blockBox4.minY() + r, blockBox4.minZ()));
                        }
                        if (Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)blockBox4).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND)) continue;
                        if (candidateElement instanceof ExclusivePoolElement) {
                            ExclusivePoolElement exclusiveElement = (ExclusivePoolElement)candidateElement;
                            if (exclusiveElement instanceof LimitedPoolElement) {
                                LimitedPoolElement limitedElement = (LimitedPoolElement)exclusiveElement;
                                this.elementsToCounts.put(limitedElement, this.elementsToCounts.get((Object)limitedElement) - 1);
                            } else if (exclusiveElement instanceof GuaranteedPoolElement) {
                                GuaranteedPoolElement guaranteedElement = (GuaranteedPoolElement)exclusiveElement;
                                this.elementsToCounts.put(guaranteedElement, this.elementsToCounts.get((Object)guaranteedElement) + 1);
                            }
                        }
                        mutableObject2.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)blockBox4)), (BooleanOp)BooleanOp.ONLY_FIRST));
                        r = parentPiece.getGroundLevelDelta();
                        int s = connectorProjectionRigid ? r - o : processedCandidateElement.getGroundLevelDelta();
                        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(this.structureTemplateManager, processedCandidateElement, blockPos6, s, rotation, blockBox4);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.getFirstFreeHeight(anchorPos.getX(), anchorPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                            }
                            t = k + o / 2;
                        }
                        parentPiece.addJunction(new JigsawJunction(candidateConnectorPos.getX(), t - anchorDistanceToFloor + r, candidateConnectorPos.getZ(), o, connectorProjection));
                        poolStructurePiece.addJunction(new JigsawJunction(anchorPos.getX(), t - connectorY + s, anchorPos.getZ(), -o, parentProjection));
                        this.piecesToPlace.add((PoolElementStructurePiece)poolStructurePiece);
                        if (depth + 1 <= this.maxSize) {
                            this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, depth + 1));
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private Holder<StructureTemplatePool> getStructurePoolEntry(ResourceKey<StructureTemplatePool> key) {
            Optional optional = this.registry.getHolder(key);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.warn("Non-existent template pool reference: {}", (Object)key.location());
            } else {
                Holder regularPool = (Holder)optional.get();
                if (((StructureTemplatePool)regularPool.value()).size() == 0) {
                    if (!regularPool.is(Pools.EMPTY)) {
                        LithostitchedCommon.LOGGER.warn("Empty template pool reference: {}", (Object)key.location());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static ResourceKey<StructureTemplatePool> getPoolKey(StructureTemplate.StructureBlockInfo blockInfo) {
            return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation(blockInfo.nbt().getString("pool")));
        }
    }

    private record ShapedPoolStructurePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int currentSize) {
    }
}

