/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface;

import com.mojang.datafixers.util.Pair;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedRegistries;
import dev.worldgen.lithostitched.worldgen.modifier.AddSurfaceRuleModifier;
import dev.worldgen.lithostitched.worldgen.surface.LithostitchedSurfaceRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SurfaceRuleManager {
    public static void applySurfaceRules(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Set surfaceRules = registryAccess.registryOrThrow(LithostitchedRegistries.WORLDGEN_MODIFIER).entrySet().stream().filter(entry -> entry.getValue() instanceof AddSurfaceRuleModifier).collect(Collectors.toSet());
        if (surfaceRules.isEmpty()) {
            return;
        }
        HashMap assignedSurfaceRules = new HashMap();
        for (Map.Entry assignedSurfaceRule : surfaceRules) {
            AddSurfaceRuleModifier slice = (AddSurfaceRuleModifier)assignedSurfaceRule.getValue();
            slice.levels().forEach(levelStemResourceKey -> assignedSurfaceRules.computeIfAbsent(levelStemResourceKey.location(), __ -> new ArrayList()).add(Pair.of((Object)((ResourceKey)assignedSurfaceRule.getKey()).location(), (Object)slice)));
        }
        Registry dimensions = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
        for (Map.Entry entry2 : dimensions.entrySet()) {
            ChunkGenerator chunkGenerator;
            ResourceLocation location = ((ResourceKey)entry2.getKey()).location();
            ArrayList surfaceRulesForKey = (ArrayList)assignedSurfaceRules.get(location);
            if (surfaceRulesForKey == null || !((chunkGenerator = ((LevelStem)entry2.getValue()).generator()) instanceof NoiseBasedChunkGenerator)) continue;
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)((NoiseBasedChunkGenerator)chunkGenerator).generatorSettings().value();
            SurfaceRules.RuleSource oldRules = settings.surfaceRule();
            ((NoiseBasedChunkGenerator)chunkGenerator).settings = Holder.direct((Object)new NoiseGeneratorSettings(settings.noiseSettings(), settings.defaultBlock(), settings.defaultFluid(), settings.noiseRouter(), SurfaceRuleManager.buildModdedSurfaceRules(surfaceRulesForKey, oldRules), settings.spawnTarget(), settings.seaLevel(), settings.disableMobGeneration(), settings.isAquifersEnabled(), settings.oreVeinsEnabled(), settings.useLegacyRandomSource()));
            LithostitchedCommon.LOGGER.info("Applied " + surfaceRulesForKey.size() + " surface rule additions for '" + location + "' dimension");
        }
    }

    private static SurfaceRules.RuleSource buildModdedSurfaceRules(ArrayList<Pair<ResourceLocation, AddSurfaceRuleModifier>> moddedSourceList, SurfaceRules.RuleSource originalSource) {
        ArrayList<SurfaceRules.RuleSource> newRuleSourceList = new ArrayList<SurfaceRules.RuleSource>();
        moddedSourceList.forEach((Consumer<Pair<ResourceLocation, AddSurfaceRuleModifier>>)((Consumer<Pair>)pair -> newRuleSourceList.add(((AddSurfaceRuleModifier)pair.getSecond()).surfaceRule())));
        newRuleSourceList.add(originalSource);
        if (originalSource instanceof LithostitchedSurfaceRules.TransientMergedRuleSource) {
            ((LithostitchedSurfaceRules.TransientMergedRuleSource)originalSource).sequence().addAll(newRuleSourceList);
            return originalSource;
        }
        return new LithostitchedSurfaceRules.TransientMergedRuleSource(newRuleSourceList, originalSource);
    }
}

