/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.events;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.network.data.LeftClickPayload;
import com.direwolf20.justdirethings.common.network.data.ToggleToolPayload;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="justdirethings", value={Dist.CLIENT})
public class EventKeyInput {
    @SubscribeEvent
    public static void handleEventInput(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || event.phase == TickEvent.Phase.START) {
            return;
        }
        ItemStack toggleableItem = ToggleableItem.getToggleableItem((Player)mc.player);
        if (!toggleableItem.isEmpty() && KeyBindings.toggleTool.consumeClick()) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleToolPayload("enabled")});
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (event.getAction() == 1) {
            for (int i = 0; i < mc.player.getInventory().items.size(); ++i) {
                ItemStack itemStack = mc.player.getInventory().getItem(i);
                Item item = itemStack.getItem();
                if (!(item instanceof ToggleableTool)) continue;
                ToggleableTool toggleableTool = (ToggleableTool)item;
                if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
                EventKeyInput.activateAbilities(itemStack, event.getKey(), toggleableTool, (Player)player, i, false);
            }
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null || event.getButton() == 0 || event.getButton() == 1 || event.getAction() != 1) {
            return;
        }
        LocalPlayer player = mc.player;
        for (int i = 0; i < mc.player.getInventory().items.size(); ++i) {
            ItemStack itemStack = mc.player.getInventory().getItem(i);
            Item item = itemStack.getItem();
            if (!(item instanceof ToggleableTool)) continue;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (!(itemStack.getItem() instanceof LeftClickableTool)) continue;
            EventKeyInput.activateAbilities(itemStack, event.getButton(), toggleableTool, (Player)player, i, true);
        }
    }

    private static void activateAbilities(ItemStack itemStack, int key, ToggleableTool toggleableTool, Player player, int invSlot, boolean isMouse) {
        Set<Ability> abilities = LeftClickableTool.getCustomBindingList(itemStack, new LeftClickableTool.Binding(key, isMouse));
        if (!abilities.isEmpty()) {
            toggleableTool.useAbility(player.level(), player, itemStack, key, isMouse);
            BlockHitResult blockHitResult = MiscTools.getHitResult(player);
            if (blockHitResult.getType() == HitResult.Type.BLOCK) {
                UseOnContext useoncontext = new UseOnContext(player.level(), player, InteractionHand.MAIN_HAND, itemStack, blockHitResult);
                toggleableTool.useOnAbility(useoncontext, itemStack, key, isMouse);
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new LeftClickPayload(0, false, BlockPos.ZERO, -1, invSlot, key, isMouse)});
        }
    }
}

