/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.events;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.network.data.LeftClickPayload;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="justdirethings")
public class PlayerEvents {
    private static BlockPos destroyPos = BlockPos.ZERO;
    private static int gameTicksMining = 0;

    @SubscribeEvent
    public static void LeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (itemStack.getItem() instanceof LeftClickableTool) {
                PlayerEvents.activateAbilities(itemStack, toggleableTool, event.getEntity(), event.getHand(), true, BlockPos.ZERO, Direction.DOWN);
            }
        }
    }

    @SubscribeEvent
    public static void LeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ToggleableTool toggleableTool;
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool) {
            toggleableTool = (ToggleableTool)item;
            if (itemStack.getItem() instanceof LeftClickableTool && event.getFace() != null && event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START) {
                PlayerEvents.activateAbilities(itemStack, toggleableTool, event.getEntity(), event.getHand(), false, event.getPos(), event.getFace());
            }
        }
        if ((item = itemStack.getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.HAMMER) && event.getFace() != null) {
            PlayerEvents.doExtraCrumblings(event, itemStack, toggleableTool);
        }
    }

    private static void doExtraCrumblings(PlayerInteractEvent.LeftClickBlock event, ItemStack itemStack, ToggleableTool toggleableTool) {
        Player player = event.getEntity();
        Level level = player.level();
        BlockPos blockPos = event.getPos();
        BlockState blockState = level.getBlockState(blockPos);
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && level.isClientSide) {
            gameTicksMining = 0;
            destroyPos = blockPos;
        }
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.STOP || event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.ABORT) {
            PlayerEvents.cancelBreaks(level, blockState, blockPos, player, toggleableTool, itemStack);
        }
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD) {
            if (blockPos.equals((Object)destroyPos)) {
                ++gameTicksMining;
            } else {
                gameTicksMining = 0;
                destroyPos = blockPos;
            }
            PlayerEvents.incrementDestroyProgress(level, blockState, blockPos, player, toggleableTool, itemStack);
        }
    }

    private static float incrementDestroyProgress(Level level, BlockState pState, BlockPos pPos, Player player, ToggleableTool toggleableTool, ItemStack toggleableToolStack) {
        Set<BlockPos> breakBlockPositions = toggleableTool.getBreakBlockPositions(toggleableToolStack, level, pPos, (LivingEntity)player, pState);
        int i = gameTicksMining;
        float f = pState.getDestroyProgress(player, (BlockGetter)player.level(), pPos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        for (BlockPos blockPos : breakBlockPositions) {
            if (blockPos.equals((Object)pPos)) continue;
            if (level.isClientSide) {
                level.destroyBlockProgress(player.getId() + PlayerEvents.generatePosHash(blockPos), blockPos, j);
                continue;
            }
            PlayerEvents.sendDestroyBlockProgress(player.getId() + PlayerEvents.generatePosHash(blockPos), blockPos, -1, (ServerPlayer)player);
        }
        return f;
    }

    private static void cancelBreaks(Level level, BlockState pState, BlockPos pPos, Player player, ToggleableTool toggleableTool, ItemStack toggleableToolStack) {
        Set<BlockPos> breakBlockPositions = toggleableTool.getBreakBlockPositions(toggleableToolStack, level, pPos, (LivingEntity)player, pState);
        for (BlockPos blockPos : breakBlockPositions) {
            if (blockPos.equals((Object)pPos)) continue;
            player.level().destroyBlockProgress(player.getId() + PlayerEvents.generatePosHash(blockPos), blockPos, -1);
        }
    }

    public static int generatePosHash(BlockPos blockPos) {
        return 961 * blockPos.getX() + 31 * blockPos.getY() + blockPos.getZ();
    }

    public static void sendDestroyBlockProgress(int pBreakerId, BlockPos pPos, int pProgress, ServerPlayer serverPlayer) {
        serverPlayer.connection.send((Packet)new ClientboundBlockDestructionPacket(pBreakerId, pPos, pProgress));
    }

    private static void activateAbilities(ItemStack itemStack, ToggleableTool toggleableTool, Player player, InteractionHand hand, boolean air, BlockPos blockPos, Direction direction) {
        Set<Ability> abilities = LeftClickableTool.getLeftClickList(itemStack);
        if (!abilities.isEmpty()) {
            if (air) {
                toggleableTool.useAbility(player.level(), player, hand, false);
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new LeftClickPayload(0, hand == InteractionHand.MAIN_HAND, BlockPos.ZERO, -1, -1, -1, false)});
            } else {
                UseOnContext useoncontext = new UseOnContext(player.level(), player, hand, itemStack, new BlockHitResult(Vec3.atCenterOf((Vec3i)blockPos), direction, blockPos, false));
                toggleableTool.useOnAbility(useoncontext, false);
            }
        }
    }
}

