/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.jei;

import com.direwolf20.justdirethings.datagen.recipes.GooSpreadRecipe;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class GooSpreadRecipeCategory
implements IRecipeCategory<GooSpreadRecipe> {
    public static final RecipeType<GooSpreadRecipe> TYPE = RecipeType.create((String)"justdirethings", (String)"goo_spread_recipe", GooSpreadRecipe.class);
    public static final int width = 120;
    public static final int height = 40;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final Component localizedName;

    public GooSpreadRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 40);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()));
        this.localizedName = Component.translatable((String)"justdirethings.goospreadrecipe.title");
    }

    public RecipeType<GooSpreadRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(GooSpreadRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.background.draw(gui, 17, 0);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GooSpreadRecipe recipe, IFocusGroup focuses) {
        BlockState input = recipe.getInput();
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 9, 12);
        if (input.getBlock().asItem() != Items.AIR) {
            inputSlotBuilder.addItemStack(new ItemStack((ItemLike)input.getBlock()));
        }
        ArrayList<ItemStack> catalystlist = new ArrayList<ItemStack>();
        if (recipe.getTierRequirement() <= 1) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()));
        }
        if (recipe.getTierRequirement() <= 2) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier2.get()));
        }
        if (recipe.getTierRequirement() <= 3) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier3.get()));
        }
        if (recipe.getTierRequirement() <= 4) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier4.get()));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStacks(catalystlist);
        BlockState output = recipe.getOutput();
        if (output.getBlock().asItem() != Items.AIR) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStack(new ItemStack((ItemLike)output.getBlock()));
        }
    }
}

