/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.renderactions;

import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class MiscRenders {
    public static void renderTransparentPlayer(RenderLevelStageEvent evt, Player player, ItemStack itemStack) {
        Vec3 renderPosition = AbilityMethods.getShiftPosition(player.level(), player, itemStack);
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        PoseStack matrixStack = evt.getPoseStack();
        matrixStack.pushPose();
        matrixStack.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        matrixStack.translate(renderPosition.x, renderPosition.y, renderPosition.z);
        int lightLevel = player.level().getMaxLocalRawBrightness(BlockPos.containing((Position)renderPosition));
        int packedLight = LightTexture.pack((int)lightLevel, (int)lightLevel);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = renderManager.getRenderer((Entity)player);
        RenderType renderType = RenderType.itemEntityTranslucentCull((ResourceLocation)renderer.getTextureLocation((Entity)player));
        VertexConsumer vertexconsumer = buffer.getBuffer(renderType);
        int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)player, (float)0.0f);
        float pPartialTicks = evt.getPartialTick();
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            float f = Mth.rotLerp((float)pPartialTicks, (float)player.yBodyRotO, (float)player.yBodyRot);
            float f1 = Mth.rotLerp((float)pPartialTicks, (float)player.yHeadRotO, (float)player.yHeadRot);
            float f2 = f1 - f;
            float f5 = Mth.lerp((float)pPartialTicks, (float)player.xRotO, (float)player.getXRot());
            float f7 = 0.0f;
            MiscRenders.setupRotations(player, matrixStack, f7, f, pPartialTicks);
            matrixStack.scale(-1.0f, -1.0f, 1.0f);
            MiscRenders.scale(player, matrixStack, pPartialTicks);
            matrixStack.translate(0.0f, -1.501f, 0.0f);
            float f8 = 0.0f;
            float f4 = 0.0f;
            if (player.isAlive()) {
                f8 = player.walkAnimation.speed(pPartialTicks);
                f4 = player.walkAnimation.position(pPartialTicks);
                if (player.isBaby()) {
                    f4 *= 3.0f;
                }
                if (f8 > 1.0f) {
                    f8 = 1.0f;
                }
            }
            EntityModel entityModel = livingRenderer.getModel();
            entityModel.attackTime = 0.0f;
            entityModel.riding = false;
            entityModel.young = player.isBaby();
            entityModel.prepareMobModel((Entity)player, f4, f8, pPartialTicks);
            entityModel.setupAnim((Entity)player, f4, f8, f7, f2, f5);
            entityModel.renderToBuffer(matrixStack, vertexconsumer, packedLight, i, 1.0f, 1.0f, 1.0f, 0.5f);
        }
        matrixStack.popPose();
    }

    protected static void setupRotations(Player pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (!pEntityLiving.hasPose(Pose.SLEEPING)) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pRotationYaw));
        }
    }

    protected static void scale(Player pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        float f = 0.9375f;
        pPoseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }
}

