/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.common.containers.FuelCanisterContainer;
import com.direwolf20.justdirethings.common.items.FuelCanister;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;

public class FuelCanisterScreen
extends AbstractContainerScreen<FuelCanisterContainer> {
    private final ResourceLocation GUI = new ResourceLocation("justdirethings", "textures/gui/fuelcanister.png");
    protected final FuelCanisterContainer container;
    private ItemStack fuelCanister;
    private boolean isAllowList;
    private boolean isCompareNBT;

    public FuelCanisterScreen(FuelCanisterContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.fuelCanister = container.fuelCanisterItemstack;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        MutableComponent msg = Component.translatable((String)"justdirethings.fuelcanisteritemsamt", (Object[])new Object[]{MagicHelpers.formatted((float)FuelCanister.getFuelLevel(this.fuelCanister) / 200.0f)});
        guiGraphics.drawString(this.font, (Component)msg, this.getGuiLeft() + this.imageWidth / 2 - this.font.width((FormattedText)msg) / 2, this.getGuiTop() + 5, Color.DARK_GRAY.getRGB(), false);
        msg = Component.translatable((String)"justdirethings.fuelcanisteramt", (Object[])new Object[]{MagicHelpers.formatted(FuelCanister.getFuelLevel(this.fuelCanister))});
        guiGraphics.drawString(this.font, (Component)msg, this.getGuiLeft() + this.imageWidth / 2 - this.font.width((FormattedText)msg) / 2, this.getGuiTop() + 15, Color.DARK_GRAY.getRGB(), false);
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (((FuelCanisterContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            int fuelPerPiece = CommonHooks.getBurnTime((ItemStack)itemstack, (RecipeType)RecipeType.SMELTING);
            List tooltip = this.getTooltipFromContainerItem(itemstack);
            if (this.container.handler.isItemValid(0, itemstack)) {
                if (FuelCanisterScreen.hasShiftDown()) {
                    tooltip.add(Component.translatable((String)"justdirethings.fuelcanisteramt", (Object[])new Object[]{MagicHelpers.formatted(fuelPerPiece)}).withStyle(ChatFormatting.AQUA));
                    tooltip.add(Component.translatable((String)"justdirethings.fuelcanisteramtstack", (Object[])new Object[]{MagicHelpers.formatted(fuelPerPiece * itemstack.getCount())}).withStyle(ChatFormatting.AQUA));
                } else {
                    tooltip.add(Component.translatable((String)"justdirethings.fuelcanisteritemsamt", (Object[])new Object[]{MagicHelpers.formatted((float)fuelPerPiece / 200.0f)}).withStyle(ChatFormatting.AQUA));
                    tooltip.add(Component.translatable((String)"justdirethings.fuelcanisteritemsamtstack", (Object[])new Object[]{MagicHelpers.formatted((float)(fuelPerPiece * itemstack.getCount()) / 200.0f)}).withStyle(ChatFormatting.AQUA));
                }
            }
            pGuiGraphics.renderTooltip(this.font, tooltip, itemstack.getTooltipImage(), itemstack, pX, pY);
        }
    }

    protected void renderSlot(GuiGraphics pGuiGraphics, Slot pSlot) {
        super.renderSlot(pGuiGraphics, pSlot);
        if (!pSlot.getItem().isEmpty() && !this.container.handler.isItemValid(pSlot.getSlotIndex(), pSlot.getItem())) {
            pGuiGraphics.fill(RenderType.guiOverlay(), pSlot.x, pSlot.y, pSlot.x + 16, pSlot.y + Mth.ceil((float)16.0f), 0x7FFF0000);
        }
    }

    public void init() {
        super.init();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        return super.mouseClicked(x, y, btn);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        return super.mouseScrolled(mouseX, mouseY, pScrollX, pScrollY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("justdirethings." + key), (Object[])args);
    }
}

