/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.containers.ToolSettingContainer;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.network.data.ToggleToolLeftRightClickPayload;
import com.direwolf20.justdirethings.common.network.data.ToggleToolSlotPayload;
import com.direwolf20.justdirethings.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class ToolSettingScreen
extends AbstractContainerScreen<ToolSettingContainer> {
    private final ResourceLocation GUI = new ResourceLocation("justdirethings", "textures/gui/settings.png");
    protected final ToolSettingContainer container;
    Player player;
    protected ItemStack tool;
    private EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    int buttonsStartX = this.getGuiLeft() + 5;
    int buttonsStartY = this.getGuiTop() + 15;
    int toolSlot;
    protected Button shownAbilityButton;
    protected final Map<Button, ExtendedSlider> sliders = new HashMap<Button, ExtendedSlider>();
    protected final Map<Button, ToggleButton> leftRightClickButtons = new HashMap<Button, ToggleButton>();
    protected final Map<Button, GrayscaleButton> bindingButtons = new HashMap<Button, GrayscaleButton>();
    protected final Map<Button, GrayscaleButton> hideRenderButtons = new HashMap<Button, GrayscaleButton>();
    protected Map<ToggleButton, LeftClickableTool.Binding> bindingMap = new HashMap<ToggleButton, LeftClickableTool.Binding>();
    protected boolean bindingEnabled = false;
    protected Set<AbstractWidget> widgetsToRemove = new HashSet<AbstractWidget>();
    protected Set<AbstractWidget> widgetsToAdd = new HashSet<AbstractWidget>();
    protected boolean renderablesChanged = false;

    public ToolSettingScreen(ToolSettingContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.player = container.playerEntity;
        if (this.player.getMainHandItem().getItem() instanceof ToggleableTool) {
            this.tool = this.player.getMainHandItem();
            this.toolSlot = this.player.getInventory().selected;
        } else if (this.player.getOffhandItem().getItem() instanceof ToggleableTool) {
            this.tool = this.player.getOffhandItem();
            this.toolSlot = 40;
        }
    }

    public void refreshButtons() {
        this.buttonsStartX = this.getGuiLeft() + 5;
        this.buttonsStartY = this.getGuiTop() + 25;
        this.clearWidgets();
        int counter = 0;
        for (final Ability toolAbility : this.abilities) {
            BaseButton button = null;
            if (toolAbility.getSettingType() == Ability.SettingType.TOGGLE) {
                isActive = ToggleableTool.getSetting(this.tool, toolAbility.getName());
                button = new GrayscaleButton(this.buttonsStartX + counter / 2 * 18, this.buttonsStartY + counter % 2 * 18, 16, 16, toolAbility.getIconLocation(), (Component)Component.translatable((String)toolAbility.getLocalization()), isActive, clicked -> {
                    this.toggleSetting(toolAbility.getName());
                    ((GrayscaleButton)clicked).toggleActive();
                });
                this.addRenderableWidget((GuiEventListener)button);
                ++counter;
            } else if (toolAbility.getSettingType() == Ability.SettingType.CYCLE) {
                isActive = ToggleableTool.getSetting(this.tool, toolAbility.getName());
                abilityParams = ((ToggleableTool)this.tool.getItem()).getAbilityParams(toolAbility);
                int possibleValues = (abilityParams.maxSlider - abilityParams.minSlider) / abilityParams.increment + 2;
                int currentValue = ToggleableTool.getToolValue(this.tool, toolAbility.getName());
                int buttonPosition = !isActive ? 0 : currentValue / abilityParams.increment;
                button = ToggleButtonFactory.ABILITYCYCLEBUTTON(this.buttonsStartX + counter / 2 * 18, this.buttonsStartY + counter % 2 * 18, toolAbility, buttonPosition, possibleValues, clicked -> this.cycleSetting(toolAbility.getName()));
                this.addRenderableWidget((GuiEventListener)button);
                ++counter;
            } else if (toolAbility.getSettingType() == Ability.SettingType.SLIDER) {
                isActive = ToggleableTool.getSetting(this.tool, toolAbility.getName());
                button = new GrayscaleButton(this.buttonsStartX + counter / 2 * 18, this.buttonsStartY + counter % 2 * 18, 16, 16, toolAbility.getIconLocation(), (Component)Component.translatable((String)toolAbility.getLocalization()), isActive, clicked -> {
                    this.toggleSetting(toolAbility.getName());
                    ((GrayscaleButton)clicked).toggleActive();
                });
                this.addRenderableWidget((GuiEventListener)button);
                abilityParams = ((ToggleableTool)this.tool.getItem()).getAbilityParams(toolAbility);
                int currentValue = ToggleableTool.getToolValue(this.tool, toolAbility.getName());
                ExtendedSlider slider = new ExtendedSlider(this.buttonsStartX + 20, this.buttonsStartY - 18, 100, 15, (Component)Component.translatable((String)toolAbility.getLocalization()).append(": "), (Component)Component.empty(), abilityParams.minSlider, abilityParams.maxSlider, currentValue, true){

                    protected void applyValue() {
                        ToolSettingScreen.this.setSetting(toolAbility.getName(), this.getValueInt());
                        super.applyValue();
                    }
                };
                this.sliders.put(button, slider);
                ++counter;
            }
            if (button != null && this.tool.getItem() instanceof LeftClickableTool && toolAbility.isBindable()) {
                int currentValue = LeftClickableTool.getBindingMode(this.tool, toolAbility);
                ToggleButton toggleButton = ToggleButtonFactory.LEFTRIGHTONLYCLICKBUTTON(this.buttonsStartX + 125, this.buttonsStartY - 18, currentValue, clicked -> {
                    LeftClickableTool.Binding binding = this.bindingMap.get((Object)((ToggleButton)clicked));
                    if (binding == null) {
                        this.sendBinding(toolAbility.getName(), ((ToggleButton)clicked).getTexturePosition(), -1, false);
                    } else {
                        this.sendBinding(toolAbility.getName(), ((ToggleButton)clicked).getTexturePosition(), binding.keyCode, binding.isMouse);
                    }
                    if (((ToggleButton)clicked).getTexturePosition() == 2) {
                        if (!this.renderables.contains((Object)this.bindingButtons.get(this.shownAbilityButton))) {
                            this.widgetsToAdd.add((AbstractWidget)this.bindingButtons.get(this.shownAbilityButton));
                        }
                    } else {
                        this.widgetsToRemove.add((AbstractWidget)this.bindingButtons.get(this.shownAbilityButton));
                    }
                    this.renderablesChanged = true;
                });
                this.leftRightClickButtons.put(button, toggleButton);
                GrayscaleButton bindingButton = ToggleButtonFactory.KEYBIND_BUTTON(this.buttonsStartX + 143, this.buttonsStartY - 18, false, clicked -> {
                    this.bindingEnabled = true;
                    ((GrayscaleButton)clicked).toggleActive();
                });
                this.bindingMap.put(toggleButton, LeftClickableTool.getAbilityBinding(this.tool, toolAbility));
                this.bindingButtons.put(button, bindingButton);
            }
            if (button == null || !toolAbility.hasRenderButton()) continue;
            boolean renderActive = true;
            GrayscaleButton hideRenderButton = ToggleButtonFactory.HIDE_RENDER_ABILITY_BUTTON(this.buttonsStartX + 143, this.buttonsStartY, renderActive, clicked -> {
                this.toggleSetting(toolAbility.getName() + "_render");
                ((GrayscaleButton)clicked).toggleActive();
            });
            this.hideRenderButtons.put(button, hideRenderButton);
        }
    }

    protected void sendBinding(String abilityName, int buttonType, int keyCode, boolean isMouse) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleToolLeftRightClickPayload(this.toolSlot, abilityName, buttonType, keyCode, isMouse)});
    }

    protected void collectButtonsToRemove() {
        this.widgetsToRemove.addAll(this.sliders.values());
        this.widgetsToRemove.addAll(this.leftRightClickButtons.values());
        this.widgetsToRemove.addAll(this.bindingButtons.values());
        this.widgetsToRemove.addAll(this.hideRenderButtons.values());
    }

    public void toggleSetting(String settingName) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleToolSlotPayload(settingName, this.toolSlot, 0, -1)});
    }

    public void cycleSetting(String settingName) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleToolSlotPayload(settingName, this.toolSlot, 1, -1)});
    }

    public void setSetting(String settingName, int value) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ToggleToolSlotPayload(settingName, this.toolSlot, 2, value)});
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!this.tool.isEmpty()) {
            int x = this.getGuiLeft() + 5;
            int y = this.getGuiTop() + 5;
            int j1 = x + y * this.imageWidth;
            int k = this.tool.getMaxStackSize();
            String s = ChatFormatting.YELLOW.toString() + k;
            guiGraphics.renderFakeItem(this.tool, x, y, j1);
            guiGraphics.renderItemDecorations(this.font, this.tool, x, y, null);
        }
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        for (Renderable renderable : this.renderables) {
            BaseButton button;
            ToggleButton button2;
            if (renderable instanceof ToggleButton && this.leftRightClickButtons.containsValue((Object)(button2 = (ToggleButton)renderable)) && button2.getTexturePosition() == 2 && !button2.getLocalization(pX, pY).equals(Component.empty())) {
                if (this.bindingMap.get((Object)button2) == null) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(button2.getLocalization(), Component.translatable((String)"justdirethings.unbound-screen"))), pX, pY);
                    continue;
                }
                LeftClickableTool.Binding binding = this.bindingMap.get((Object)button2);
                if (binding.isMouse) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(button2.getLocalization(), Component.translatable((String)"justdirethings.bound-mouse", (Object[])new Object[]{binding.keyCode}))), pX, pY);
                    continue;
                }
                String bindingName = InputConstants.getKey((int)binding.keyCode, (int)0).getDisplayName().getString();
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(button2.getLocalization(), Component.translatable((String)"justdirethings.bound-key", (Object[])new Object[]{bindingName}))), pX, pY);
                continue;
            }
            if (!(renderable instanceof BaseButton) || (button = (BaseButton)renderable).getLocalization(pX, pY).equals(Component.empty())) continue;
            if (this.sliders.containsKey((Object)button) || this.leftRightClickButtons.containsKey((Object)button)) {
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(button.getLocalization(), Component.translatable((String)"justdirethings.screen.rightclicksettings"))), pX, pY);
                continue;
            }
            pGuiGraphics.renderTooltip(this.font, button.getLocalization(), pX, pY);
        }
    }

    protected void renderSlot(GuiGraphics pGuiGraphics, Slot pSlot) {
        super.renderSlot(pGuiGraphics, pSlot);
    }

    public void init() {
        super.init();
        Item item = this.tool.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            this.abilities = toggleableTool.getAbilities();
            this.refreshButtons();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        if (this.renderablesChanged) {
            this.updateRenderables();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.shownAbilityButton != null && this.leftRightClickButtons.get(this.shownAbilityButton) != null && this.bindingButtons.get(this.shownAbilityButton) != null && this.bindingEnabled) {
            if (pKeyCode == 256) {
                this.bindingMap.put(this.leftRightClickButtons.get(this.shownAbilityButton), null);
                this.leftRightClickButtons.get(this.shownAbilityButton).onPress();
                this.bindingButtons.get(this.shownAbilityButton).toggleActive();
                this.bindingEnabled = false;
                return true;
            }
            this.bindingMap.put(this.leftRightClickButtons.get(this.shownAbilityButton), new LeftClickableTool.Binding(pKeyCode, false));
            this.leftRightClickButtons.get(this.shownAbilityButton).onPress();
            this.bindingButtons.get(this.shownAbilityButton).toggleActive();
            this.bindingEnabled = false;
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        Item item;
        if (btn != 0 && btn != 1 && this.shownAbilityButton != null && this.leftRightClickButtons.get(this.shownAbilityButton) != null && this.bindingButtons.get(this.shownAbilityButton) != null && this.bindingEnabled) {
            this.bindingMap.put(this.leftRightClickButtons.get(this.shownAbilityButton), new LeftClickableTool.Binding(btn, true));
            this.leftRightClickButtons.get(this.shownAbilityButton).onPress();
            this.bindingButtons.get(this.shownAbilityButton).toggleActive();
            this.bindingEnabled = false;
            return true;
        }
        if (this.hoveredSlot != null && (item = this.hoveredSlot.getItem().getItem()) instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            this.tool = this.hoveredSlot.getItem();
            this.toolSlot = this.hoveredSlot.getSlotIndex();
            this.abilities = toggleableTool.getAbilities();
            this.refreshButtons();
            return true;
        }
        if (btn == 1) {
            for (Renderable renderable : new ArrayList(this.renderables)) {
                Button button;
                if (!(renderable instanceof Button) || !this.sliders.containsKey(button = (Button)renderable) && !this.leftRightClickButtons.containsKey(button) && !this.bindingButtons.containsKey(button) && !this.hideRenderButtons.containsKey(button) || !MiscTools.inBounds(button.getX(), button.getY(), button.getWidth(), button.getHeight(), x, y)) continue;
                this.collectButtonsToRemove();
                this.shownAbilityButton = button.equals(this.shownAbilityButton) ? null : button;
                if (this.sliders.containsKey(this.shownAbilityButton)) {
                    this.widgetsToAdd.add((AbstractWidget)this.sliders.get(this.shownAbilityButton));
                }
                if (this.leftRightClickButtons.containsKey(this.shownAbilityButton)) {
                    this.widgetsToAdd.add((AbstractWidget)this.leftRightClickButtons.get(this.shownAbilityButton));
                }
                if (this.bindingButtons.containsKey(this.shownAbilityButton) && this.leftRightClickButtons.get(this.shownAbilityButton).getTexturePosition() == 2) {
                    this.widgetsToAdd.add((AbstractWidget)this.bindingButtons.get(this.shownAbilityButton));
                }
                if (this.hideRenderButtons.containsKey(this.shownAbilityButton)) {
                    this.widgetsToAdd.add((AbstractWidget)this.hideRenderButtons.get(this.shownAbilityButton));
                }
                button.playDownSound(Minecraft.getInstance().getSoundManager());
            }
            if (this.widgetsToRemove.size() > 0 || this.widgetsToAdd.size() > 0) {
                this.renderablesChanged = true;
                return true;
            }
        }
        return super.mouseClicked(x, y, btn);
    }

    public void updateRenderables() {
        if (!this.widgetsToRemove.isEmpty()) {
            for (AbstractWidget abstractWidget : this.widgetsToRemove) {
                this.removeWidget((GuiEventListener)abstractWidget);
            }
            this.widgetsToRemove.clear();
        }
        if (!this.widgetsToAdd.isEmpty()) {
            for (AbstractWidget abstractWidget : this.widgetsToAdd) {
                this.addRenderableWidget((GuiEventListener)abstractWidget);
            }
            this.widgetsToAdd.clear();
        }
        this.renderablesChanged = false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        return super.mouseScrolled(mouseX, mouseY, pScrollX, pScrollY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("justdirethings." + key), (Object[])args);
    }
}

