/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.FakePlayerUtil;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class BlockPlacerT1BE
extends BaseMachineBE
implements RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    List<BlockPos> positionsToPlace = new ArrayList<BlockPos>();

    public BlockPlacerT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
    }

    public BlockPlacerT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.BlockPlacerT1BE.get(), pPos, pBlockState);
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doBlockPlace();
    }

    public ItemStack getPlaceStack() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    public boolean isStackValid(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        return itemStack.getItem() instanceof BlockItem;
    }

    public boolean canPlace() {
        return true;
    }

    public boolean clearTrackerIfNeeded(ItemStack itemStack) {
        if (this.positionsToPlace.isEmpty()) {
            return false;
        }
        if (!this.isStackValid(itemStack)) {
            return true;
        }
        if (!this.canPlace()) {
            return true;
        }
        return !this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
    }

    public void doBlockPlace() {
        ItemStack placeStack = this.getPlaceStack();
        if (!this.isStackValid(placeStack)) {
            return;
        }
        if (this.clearTrackerIfNeeded(placeStack)) {
            this.positionsToPlace.clear();
            return;
        }
        if (!this.canPlace()) {
            return;
        }
        UsefulFakePlayer fakePlayer = this.getUsefulFakePlayer((ServerLevel)this.level);
        if (this.isActiveRedstone() && this.canRun() && this.positionsToPlace.isEmpty()) {
            this.positionsToPlace = this.findSpotsToPlace(fakePlayer);
        }
        if (this.positionsToPlace.isEmpty()) {
            return;
        }
        if (this.canRun()) {
            BlockPos blockPos = this.positionsToPlace.remove(0);
            Direction placing = this.getDirectionValue();
            FakePlayerUtil.setupFakePlayerForUse(fakePlayer, blockPos, placing, placeStack, false);
            this.placeBlock(placeStack, fakePlayer, blockPos);
            FakePlayerUtil.cleanupFakePlayerFromUse(fakePlayer, fakePlayer.getMainHandItem());
        }
    }

    public InteractionResult placeBlock(ItemStack itemStack, FakePlayer fakePlayer, BlockPos blockPos) {
        Direction placing = this.getDirectionValue();
        Vec3 hitVec = Vec3.atCenterOf((Vec3i)blockPos);
        BlockHitResult hitResult = new BlockHitResult(hitVec, placing, blockPos, false);
        UseOnContext useoncontext = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, hitResult);
        return itemStack.useOn(useoncontext);
    }

    public boolean isBlockPosValid(FakePlayer fakePlayer, BlockPos blockPos) {
        if (!this.level.mayInteract((Player)fakePlayer, blockPos)) {
            return false;
        }
        return this.level.getBlockState(blockPos).canBeReplaced();
    }

    public List<BlockPos> findSpotsToPlace(FakePlayer fakePlayer) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(fakePlayer, blockPos)) {
            returnList.add(blockPos);
        }
        return returnList;
    }
}

