/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.BlockSwapperT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockSwapperT2BE
extends BlockSwapperT1BE
implements PoweredMachineBE,
AreaAffectingBE,
FilterableBE {
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData(this);

    public BlockSwapperT2BE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.BlockSwapperT2BE.get(), pPos, pBlockState);
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 50;
    }

    public int getEnergyCost(int numBlocks) {
        return numBlocks * this.getStandardEnergyCost();
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public boolean isValidPartner(BlockEntity blockEntity) {
        return blockEntity.getClass() == this.getClass();
    }

    public void setAreaOnly(double x, double y, double z) {
        this.getAreaAffectingData().xRadius = Math.max(0.0, Math.min(x, 5.0));
        this.getAreaAffectingData().yRadius = Math.max(0.0, Math.min(y, 5.0));
        this.getAreaAffectingData().zRadius = Math.max(0.0, Math.min(z, 5.0));
        this.getAreaAffectingData().area = null;
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
    }

    public void updatePartnerArea() {
        BlockSwapperT1BE partnerBE = this.getPartnerBE();
        if (partnerBE instanceof BlockSwapperT2BE) {
            BlockSwapperT2BE blockSwapperT2BE = (BlockSwapperT2BE)partnerBE;
            blockSwapperT2BE.setAreaOnly(this.getAreaAffectingData().xRadius, this.getAreaAffectingData().yRadius, this.getAreaAffectingData().zRadius);
        }
    }

    @Override
    public void addPartnerConnection(GlobalPos connectingPos, BlockSwapperT1BE be) {
        super.addPartnerConnection(connectingPos, be);
        this.updatePartnerArea();
    }

    @Override
    public void setAreaSettings(double x, double y, double z, int xo, int yo, int zo, boolean renderArea) {
        AreaAffectingBE.super.setAreaSettings(x, y, z, xo, yo, zo, renderArea);
        this.updatePartnerArea();
    }

    @Override
    public boolean canSwap() {
        AABB aabb = this.getAABB(this.getBlockPos());
        int width = (int)Math.abs(Math.floor(aabb.maxX) - Math.floor(aabb.minX));
        int height = (int)Math.abs(Math.floor(aabb.maxY) - Math.floor(aabb.minY));
        int depth = (int)Math.abs(Math.floor(aabb.maxZ) - Math.floor(aabb.minZ));
        return this.hasEnoughPower(this.getEnergyCost(width * height * depth));
    }

    @Override
    public void postSwap(int numBlocks) {
        this.extractEnergy(this.getEnergyCost(numBlocks), false);
    }

    @Override
    public BlockPos getStartingPoint() {
        return this.getBlockPos().offset(this.getAreaAffectingData().xOffset, this.getAreaAffectingData().yOffset, this.getAreaAffectingData().zOffset);
    }

    public boolean isInBothAreas(BlockPos blockPos) {
        BlockSwapperT1BE partnerBE = this.getPartnerBE();
        if (!this.level.equals(partnerBE.getLevel())) {
            return false;
        }
        if (partnerBE instanceof BlockSwapperT2BE) {
            BlockSwapperT2BE partnerSwapper = (BlockSwapperT2BE)partnerBE;
            AABB thisAABB = this.getAABB(this.getBlockPos());
            AABB thatAABB = partnerSwapper.getAABB(partnerSwapper.getBlockPos());
            return thisAABB.contains((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()) && thatAABB.contains((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        }
        return false;
    }

    public boolean isInBothAreas(Vec3 vec3) {
        if (!this.isSameLevel()) {
            return false;
        }
        BlockSwapperT1BE blockSwapperT1BE = this.getPartnerBE();
        if (blockSwapperT1BE instanceof BlockSwapperT2BE) {
            BlockSwapperT2BE partnerSwapper = (BlockSwapperT2BE)blockSwapperT1BE;
            AABB thisAABB = this.getAABB(this.getBlockPos());
            AABB thatAABB = partnerSwapper.getAABB(partnerSwapper.getBlockPos());
            return thisAABB.contains(vec3.x(), vec3.y(), vec3.z()) && thatAABB.contains(vec3.x(), vec3.y(), vec3.z());
        }
        return false;
    }

    @Override
    public boolean isBlockPosValid(ServerLevel serverLevel, BlockPos blockPos) {
        if (!super.isBlockPosValid(serverLevel, blockPos)) {
            return false;
        }
        if (this.isInBothAreas(blockPos)) {
            return false;
        }
        BlockState blockState = serverLevel.getBlockState(blockPos);
        if (blockState.isAir()) {
            return true;
        }
        ItemStack blockItemStack = blockState.getBlock().getCloneItemStack((LevelReader)serverLevel, blockPos, blockState);
        return this.isStackValidFilter(blockItemStack);
    }

    @Override
    public AABB getAABB() {
        return this.getAABB(this.getBlockPos());
    }

    @Override
    public List<BlockPos> findSpotsToSwap() {
        AABB area = this.getAABB(this.getBlockPos());
        return BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).filter(blockPos -> this.isBlockPosValid((ServerLevel)this.level, (BlockPos)blockPos)).map(BlockPos::immutable).sorted(Comparator.comparingDouble(x -> x.distSqr((Vec3i)this.getBlockPos()))).collect(Collectors.toList());
    }

    @Override
    public boolean isValidEntity(Entity entity) {
        if (!super.isValidEntity(entity)) {
            return false;
        }
        if (this.isInBothAreas(entity.position())) {
            return false;
        }
        SpawnEggItem eggItem = SpawnEggItem.byId((EntityType)entity.getType());
        ItemStack eggItemStack = eggItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)eggItem);
        return this.isStackValidFilter(eggItemStack);
    }
}

