/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.ClickerT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class ClickerT2BE
extends ClickerT1BE
implements PoweredMachineBE,
AreaAffectingBE,
FilterableBE {
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData(this);

    public ClickerT2BE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.ClickerT2BE.get(), pPos, pBlockState);
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 250;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.chargeItemStack(this.getClickStack());
    }

    @Override
    public boolean canClick() {
        return this.hasEnoughPower(this.getStandardEnergyCost());
    }

    @Override
    public InteractionResult clickEntity(ItemStack itemStack, UsefulFakePlayer fakePlayer, LivingEntity entity) {
        InteractionResult interactionResult = super.clickEntity(itemStack, fakePlayer, entity);
        if (interactionResult.equals((Object)InteractionResult.SUCCESS)) {
            this.extractEnergy(this.getStandardEnergyCost(), false);
        }
        return interactionResult;
    }

    @Override
    public InteractionResult clickBlock(ItemStack itemStack, UsefulFakePlayer fakePlayer, BlockPos blockPos) {
        InteractionResult interactionResult = super.clickBlock(itemStack, fakePlayer, blockPos);
        if (interactionResult.equals((Object)InteractionResult.SUCCESS)) {
            this.extractEnergy(this.getStandardEnergyCost(), false);
        }
        return interactionResult;
    }

    @Override
    public boolean isBlockPosValid(FakePlayer fakePlayer, BlockPos blockPos) {
        if (!super.isBlockPosValid(fakePlayer, blockPos)) {
            return false;
        }
        ItemStack blockItemStack = this.level.getBlockState(blockPos).getCloneItemStack((HitResult)new BlockHitResult(Vec3.ZERO, this.getDirectionValue(), blockPos, false), (LevelReader)this.level, blockPos, (Player)fakePlayer);
        return this.isStackValidFilter(blockItemStack);
    }

    @Override
    public List<BlockPos> findSpotsToClick(FakePlayer fakePlayer) {
        AABB area = this.getAABB(this.getBlockPos());
        return BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).filter(blockPos -> this.isBlockPosValid(fakePlayer, (BlockPos)blockPos)).map(BlockPos::immutable).sorted(Comparator.comparingDouble(x -> x.distSqr((Vec3i)this.getBlockPos()))).collect(Collectors.toList());
    }

    @Override
    public AABB getAABB() {
        return this.getAABB(this.getBlockPos());
    }

    @Override
    public boolean isValidEntity(Entity entity) {
        if (!super.isValidEntity(entity)) {
            return false;
        }
        SpawnEggItem eggItem = SpawnEggItem.byId((EntityType)entity.getType());
        ItemStack eggItemStack = eggItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)eggItem);
        return this.isStackValidFilter(eggItemStack);
    }
}

