/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.setup.Registration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EclipseGateBE
extends BlockEntity {
    public byte lifetime;
    public BlockState sourceBlock;

    public EclipseGateBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.EclipseGateBE.get(), pos, state);
    }

    public void tickClient() {
    }

    public void tickServer() {
        this.tickLifetime();
        if (this.lifetime >= this.getMaxLife()) {
            this.setRealBlock(this.sourceBlock);
        }
    }

    public void setSourceBlock(BlockState blockState) {
        this.sourceBlock = blockState;
    }

    public byte getMaxLife() {
        return 100;
    }

    public void setRealBlock(BlockState realBlock) {
        List drops;
        Iterator iterator;
        if (realBlock == null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        if (!realBlock.canSurvive((LevelReader)this.level, this.getBlockPos()) && (iterator = (drops = Block.getDrops((BlockState)realBlock, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.getBlockPos(), null)).iterator()).hasNext()) {
            ItemStack returnedItem = (ItemStack)iterator.next();
            ItemEntity itementity = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), returnedItem);
            itementity.setPickUpDelay(40);
            this.level.addFreshEntity((Entity)itementity);
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        BlockState adjustedState = Block.updateFromNeighbourShapes((BlockState)realBlock, (LevelAccessor)this.level, (BlockPos)this.getBlockPos());
        this.level.setBlockAndUpdate(this.getBlockPos(), adjustedState);
    }

    public void tickLifetime() {
        this.lifetime = (byte)(this.lifetime + 1);
        if (this.lifetime >= this.getMaxLife()) {
            this.lifetime = this.getMaxLife();
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.sourceBlock = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("sourceBlock"));
        this.lifetime = tag.getByte("lifetime");
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.sourceBlock != null) {
            tag.put("sourceBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.sourceBlock));
            tag.putByte("lifetime", this.lifetime);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.getTag() == null) {
            return;
        }
        this.load(pkt.getTag());
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }
}

