/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.blocks.EnergyTransmitter;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageNoReceive;
import com.direwolf20.justdirethings.common.capabilities.TransmitterEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.items.PocketGenerator;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyTransmitterBE
extends BaseMachineBE
implements RedstoneControlledBE,
PoweredMachineBE,
AreaAffectingBE,
FilterableBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final PoweredMachineContainerData poweredMachineData;
    private final Map<BlockPos, BlockCapabilityCache<IEnergyStorage, Direction>> energyHandlers = new HashMap<BlockPos, BlockCapabilityCache<IEnergyStorage, Direction>>();
    private final Map<BlockPos, BlockCapabilityCache<IEnergyStorage, Direction>> transmitterHandlers = new HashMap<BlockPos, BlockCapabilityCache<IEnergyStorage, Direction>>();
    private final Set<BlockPos> blocksToCharge = new HashSet<BlockPos>();
    private final Set<BlockPos> transmitters = new HashSet<BlockPos>();
    public AreaAffectingData areaAffectingData = new AreaAffectingData();
    public FilterData filterData = new FilterData();
    public boolean showParticles = true;

    public EnergyTransmitterBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
        this.poweredMachineData = new PoweredMachineContainerData(this);
        this.tickSpeed = 50;
    }

    public EnergyTransmitterBE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.EnergyTransmitterBE.get(), pPos, pBlockState);
    }

    public void setEnergyTransmitterSettings(boolean showParticles) {
        this.showParticles = showParticles;
        this.markDirtyClient();
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public TransmitterEnergyStorage getEnergyStorage() {
        return (TransmitterEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_TRANSMITTERS));
    }

    @Override
    public int getEnergyStored() {
        return this.getEnergyStorage().getRealEnergyStored();
    }

    @Override
    public int getStandardEnergyCost() {
        return 0;
    }

    @Override
    public void tickClient() {
    }

    public Map<BlockPos, TransmitterEnergyStorage> getTransmitterEnergyStorages() {
        return this.transmitters.stream().map(pos -> new AbstractMap.SimpleEntry<BlockPos, TransmitterEnergyStorage>((BlockPos)pos, this.getTransmitterEnergyHandler((BlockPos)pos))).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void balanceEnergy() {
        int remainder;
        int count;
        int totalEnergy;
        int averageEnergy;
        if (this.transmitters.isEmpty() || this.transmitters.size() == 1) {
            return;
        }
        Map<BlockPos, TransmitterEnergyStorage> transmitterEnergyStorages = this.getTransmitterEnergyStorages();
        if (this.isAlreadyBalanced(transmitterEnergyStorages, averageEnergy = (totalEnergy = transmitterEnergyStorages.values().stream().mapToInt(TransmitterEnergyStorage::getRealEnergyStored).sum()) / (count = transmitterEnergyStorages.size()), remainder = totalEnergy % count)) {
            return;
        }
        int i = 0;
        for (Map.Entry<BlockPos, TransmitterEnergyStorage> entry : transmitterEnergyStorages.entrySet()) {
            if (i < remainder) {
                entry.getValue().setEnergy(averageEnergy + 1);
            } else {
                entry.getValue().setEnergy(averageEnergy);
            }
            ++i;
            this.doParticles(this.getBlockPos(), entry.getKey());
        }
    }

    private boolean isAlreadyBalanced(Map<BlockPos, TransmitterEnergyStorage> transmitterEnergyStorages, int averageEnergy, int remainder) {
        int minEnergy = averageEnergy;
        int maxEnergy = averageEnergy + (remainder > 0 ? 1 : 0);
        return transmitterEnergyStorages.values().stream().allMatch(transmitterEnergyStorage -> {
            int energy = transmitterEnergyStorage.getRealEnergyStored();
            return energy == minEnergy || energy == maxEnergy;
        });
    }

    public int getTotalEnergyStored() {
        return this.getTransmitterEnergyStorages().values().stream().mapToInt(TransmitterEnergyStorage::getRealEnergyStored).sum();
    }

    public int getTotalMaxEnergyStored() {
        return this.getTransmitterEnergyStorages().values().stream().mapToInt(TransmitterEnergyStorage::getRealMaxEnergyStored).sum();
    }

    public int distributeEnergy(int energy) {
        int energyInserted = 0;
        for (TransmitterEnergyStorage transmitterEnergyStorage : this.getTransmitterEnergyStorages().values()) {
            int insertedEnergy = transmitterEnergyStorage.realReceiveEnergy(energy, false);
            energyInserted += insertedEnergy;
            if ((energy -= insertedEnergy) > 0) continue;
            break;
        }
        return energyInserted;
    }

    public int extractEnergy(int energy) {
        int energyExtracted = 0;
        for (TransmitterEnergyStorage transmitterEnergyStorage : this.getTransmitterEnergyStorages().values()) {
            int extractedEnergy = transmitterEnergyStorage.realExtractEnergy(energy, false);
            energyExtracted += extractedEnergy;
            if ((energy -= extractedEnergy) > 0) continue;
            break;
        }
        return energyExtracted;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.isActiveRedstone()) {
            if (this.canRun()) {
                this.getBlocksToCharge();
            }
            this.drainFromSlot();
            this.providePower();
        }
    }

    public void doParticles(BlockPos sourcePos, BlockPos targetPos) {
        if (!this.showParticles) {
            return;
        }
        Direction sourceFacing = (Direction)this.level.getBlockState(sourcePos).getValue((Property)BlockStateProperties.FACING);
        Vec3 sourceVec = new Vec3((double)((float)sourcePos.getX() + 0.5f) - 0.3 * (double)sourceFacing.getStepX(), (double)((float)sourcePos.getY() + 0.5f) - 0.3 * (double)sourceFacing.getStepY(), (double)((float)sourcePos.getZ() + 0.5f) - 0.3 * (double)sourceFacing.getStepZ());
        BlockState targetState = this.level.getBlockState(targetPos);
        Vec3 targetVec = new Vec3(0.0, 0.0, 0.0);
        if (targetState.getBlock() instanceof EnergyTransmitter) {
            Direction targetFacing = (Direction)targetState.getValue((Property)BlockStateProperties.FACING);
            targetVec = new Vec3((double)((float)targetPos.getX() + 0.5f) - 0.3 * (double)targetFacing.getStepX(), (double)((float)targetPos.getY() + 0.5f) - 0.3 * (double)targetFacing.getStepY(), (double)((float)targetPos.getZ() + 0.5f) - 0.3 * (double)targetFacing.getStepZ());
        } else {
            VoxelShape voxelShape = targetState.getShape((BlockGetter)this.level, targetPos);
            targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        }
        ItemFlowParticleData data = new ItemFlowParticleData(new ItemStack((ItemLike)Items.YELLOW_CONCRETE), targetVec.x, targetVec.y, targetVec.z, 2);
        double d0 = sourceVec.x();
        double d1 = sourceVec.y();
        double d2 = sourceVec.z();
        ((ServerLevel)this.level).sendParticles((ParticleOptions)data, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void drainFromSlot() {
        ItemStack itemStack = this.getMachineHandler().getStackInSlot(0);
        if (itemStack.isEmpty()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return;
        }
        Item item = itemStack.getItem();
        if (item instanceof PocketGenerator) {
            PocketGenerator pocketGenerator = (PocketGenerator)item;
            pocketGenerator.tryBurn((EnergyStorageNoReceive)energyStorage, itemStack);
        }
        if (this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored()) {
            return;
        }
        this.transmitPower(energyStorage, (IEnergyStorage)this.getEnergyStorage(), this.fePerTick());
    }

    public IEnergyStorage getHandler(BlockPos blockPos) {
        BlockCapabilityCache tempStorage = this.energyHandlers.get(blockPos);
        if (tempStorage == null) {
            boolean foundAcceptableSide = false;
            for (Direction direction : Direction.values()) {
                tempStorage = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)blockPos, (Object)direction);
                if (tempStorage.getCapability() == null || !((IEnergyStorage)tempStorage.getCapability()).canReceive()) continue;
                this.energyHandlers.put(blockPos, (BlockCapabilityCache<IEnergyStorage, Direction>)tempStorage);
                foundAcceptableSide = true;
                break;
            }
            if (!foundAcceptableSide) {
                this.energyHandlers.put(blockPos, tempStorage);
            }
        }
        return (IEnergyStorage)tempStorage.getCapability();
    }

    public TransmitterEnergyStorage getTransmitterEnergyHandler(BlockPos blockPos) {
        IEnergyStorage iEnergyStorage = this.getTransmitterHandler(blockPos);
        if (iEnergyStorage instanceof TransmitterEnergyStorage) {
            TransmitterEnergyStorage transmitterEnergyStorage = (TransmitterEnergyStorage)iEnergyStorage;
            return transmitterEnergyStorage;
        }
        return null;
    }

    public IEnergyStorage getTransmitterHandler(BlockPos blockPos) {
        BlockCapabilityCache tempStorage = this.transmitterHandlers.get(blockPos);
        if (tempStorage == null) {
            BlockState blockState = this.level.getBlockState(blockPos);
            if (blockState.is((Block)Registration.EnergyTransmitter.get()) && (tempStorage = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)blockPos, (Object)((Direction)blockState.getValue((Property)BlockStateProperties.FACING)))).getCapability() != null) {
                this.transmitterHandlers.put(blockPos, (BlockCapabilityCache<IEnergyStorage, Direction>)tempStorage);
                return (IEnergyStorage)tempStorage.getCapability();
            }
            this.energyHandlers.put(blockPos, tempStorage);
        }
        return (IEnergyStorage)tempStorage.getCapability();
    }

    public void providePower() {
        if (this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (BlockPos blockPos : this.blocksToCharge) {
            int sentAmt;
            IEnergyStorage iEnergyStorage = this.getHandler(blockPos);
            if (iEnergyStorage == null || (sentAmt = this.transmitPowerWithLoss((IEnergyStorage)this.getEnergyStorage(), iEnergyStorage, this.fePerTick(), blockPos)) <= 0) continue;
            this.doParticles(this.getBlockPos(), blockPos);
        }
        this.balanceEnergy();
    }

    public int calculateLoss(int amtToSend, BlockPos remotePosition) {
        double energyLoss = (Double)Config.ENERGY_TRANSMITTER_T1_LOSS_PER_BLOCK.get() * (double)Math.abs(this.getBlockPos().distManhattan((Vec3i)remotePosition)) / 100.0;
        return amtToSend - (int)Math.floor((double)amtToSend * energyLoss);
    }

    public int transmitPowerWithLoss(IEnergyStorage sender, IEnergyStorage receiver, int amtToSend, BlockPos remotePosition) {
        int amtFit = receiver.receiveEnergy(amtToSend, true);
        if (amtFit <= 0) {
            return 0;
        }
        int extractAmt = sender.extractEnergy(amtFit, false);
        return receiver.receiveEnergy(this.calculateLoss(extractAmt, remotePosition), false);
    }

    public int transmitPower(IEnergyStorage sender, IEnergyStorage receiver, int amtToSend) {
        int amtFit = receiver.receiveEnergy(amtToSend, true);
        if (amtFit <= 0) {
            return 0;
        }
        int extractAmt = sender.extractEnergy(amtFit, false);
        return receiver.receiveEnergy(extractAmt, false);
    }

    public void getBlocksToCharge() {
        this.transmitters.clear();
        this.blocksToCharge.clear();
        this.transmitters.add(this.getBlockPos());
        AABB area = this.getAABB(this.getBlockPos());
        BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).map(BlockPos::immutable).sorted(Comparator.comparingDouble(x -> x.distSqr((Vec3i)this.getBlockPos()))).forEach(blockPos -> {
            if (blockPos.equals((Object)this.getBlockPos())) {
                return;
            }
            BlockState blockState = this.level.getBlockState(blockPos);
            if (blockState.isAir() || this.level.getBlockEntity(blockPos) == null) {
                return;
            }
            boolean foundAcceptableSide = false;
            for (Direction direction : Direction.values()) {
                IEnergyStorage cap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, (Object)direction);
                if (cap == null || !cap.canReceive()) continue;
                foundAcceptableSide = true;
                break;
            }
            if (!foundAcceptableSide) {
                return;
            }
            ItemStack blockItemStack = blockState.getBlock().getCloneItemStack((LevelReader)this.level, blockPos, blockState);
            if (!this.isStackValidFilter(blockItemStack)) {
                return;
            }
            if (blockState.getBlock() instanceof EnergyTransmitter) {
                this.transmitters.add((BlockPos)blockPos);
            } else {
                this.blocksToCharge.add((BlockPos)blockPos);
            }
        });
        this.energyHandlers.entrySet().removeIf(entry -> !this.blocksToCharge.contains(entry.getKey()));
        this.transmitterHandlers.entrySet().removeIf(entry -> !this.transmitters.contains(entry.getKey()));
    }

    public int fePerTick() {
        return (Integer)Config.ENERGY_TRANSMITTER_T1_RF_PER_TICK.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.ENERGY_TRANSMITTER_T1_MAX_RF.get();
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        return this.showParticles;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putBoolean("showParticles", this.showParticles);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("showParticles")) {
            this.showParticles = tag.getBoolean("showParticles");
        }
    }
}

