/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageNoReceive;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.items.FuelCanister;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class GeneratorT1BE
extends BaseMachineBE
implements RedstoneControlledBE,
PoweredMachineBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final ContainerData poweredMachineData;
    public int maxBurn = 0;
    public int burnRemaining = 0;
    public int feRemaining = 0;
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> energyHandlers = new HashMap<Direction, BlockCapabilityCache<IEnergyStorage, Direction>>();
    int fuelBurnMultiplier = 1;

    public GeneratorT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
        this.poweredMachineData = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> GeneratorT1BE.this.getEnergyStored() & 0xFFFF;
                    case 1 -> GeneratorT1BE.this.getEnergyStored() >> 16;
                    case 2 -> GeneratorT1BE.this.burnRemaining;
                    case 3 -> GeneratorT1BE.this.maxBurn;
                    default -> throw new IllegalArgumentException("Invalid index: " + index);
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneratorT1BE.this.setEnergyStored(GeneratorT1BE.this.getEnergyStored() & 0xFFFF0000 | value & 0xFFFF);
                        break;
                    }
                    case 1: {
                        GeneratorT1BE.this.setEnergyStored(GeneratorT1BE.this.getEnergyStored() & 0xFFFF | value << 16);
                        break;
                    }
                    case 2: {
                        GeneratorT1BE.this.burnRemaining = value;
                        break;
                    }
                    case 3: {
                        GeneratorT1BE.this.maxBurn = value;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid index: " + index);
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public GeneratorT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.GeneratorT1BE.get(), pPos, pBlockState);
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_GENERATORS));
    }

    @Override
    public int getStandardEnergyCost() {
        return 0;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doGenerate();
        this.providePowerAdjacent();
    }

    @Override
    public int insertEnergy(int power, boolean simulate) {
        MachineEnergyStorage energyStorage = this.getEnergyStorage();
        if (energyStorage instanceof EnergyStorageNoReceive) {
            EnergyStorageNoReceive energyStorageNoReceive = (EnergyStorageNoReceive)energyStorage;
            return energyStorageNoReceive.forceReceiveEnergy(power, simulate);
        }
        return 0;
    }

    public IEnergyStorage getHandler(Direction direction) {
        BlockCapabilityCache tempStorage = this.energyHandlers.get(direction);
        if (tempStorage == null) {
            BlockPos targetPos = this.getBlockPos().relative(direction);
            tempStorage = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (Object)direction.getOpposite());
            this.energyHandlers.put(direction, (BlockCapabilityCache<IEnergyStorage, Direction>)tempStorage);
        }
        return (IEnergyStorage)tempStorage.getCapability();
    }

    public void providePowerAdjacent() {
        if (this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int amtFit;
            IEnergyStorage iEnergyStorage = this.getHandler(direction);
            if (iEnergyStorage == null || (amtFit = iEnergyStorage.receiveEnergy(this.getFEPerTick(), true)) <= 0) continue;
            int extractAmt = this.extractEnergy(amtFit, false);
            iEnergyStorage.receiveEnergy(extractAmt, false);
        }
    }

    public void doBurn() {
        boolean canInsertEnergy;
        if (this.feRemaining > 0) {
            return;
        }
        this.maxBurn = 0;
        this.burnRemaining = 0;
        boolean bl = canInsertEnergy = this.insertEnergy(this.fePerTick(), true) > 0;
        if (!canInsertEnergy) {
            return;
        }
        ItemStack fuelStack = this.getMachineHandler().getStackInSlot(0);
        if (fuelStack.isEmpty()) {
            return;
        }
        int oldMultiplier = this.fuelBurnMultiplier;
        int burnTime = fuelStack.getBurnTime(RecipeType.SMELTING);
        if (burnTime <= 0) {
            return;
        }
        Item item = fuelStack.getItem();
        if (item instanceof Coal_T1) {
            Coal_T1 direCoal = (Coal_T1)item;
            this.fuelBurnMultiplier = direCoal.getBurnSpeedMultiplier();
        } else {
            BlockItem blockItem;
            item = fuelStack.getItem();
            if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                CoalBlock_T1 coalBlock = (CoalBlock_T1)item;
                this.fuelBurnMultiplier = coalBlock.getBurnSpeedMultiplier();
            } else {
                item = fuelStack.getItem();
                if (item instanceof FuelCanister) {
                    FuelCanister fuelCanister = (FuelCanister)item;
                    this.fuelBurnMultiplier = FuelCanister.getBurnSpeedMultiplier(fuelStack);
                } else {
                    this.fuelBurnMultiplier = 1;
                }
            }
        }
        if (this.fuelBurnMultiplier != oldMultiplier) {
            this.markDirtyClient();
        }
        if (fuelStack.hasCraftingRemainingItem()) {
            this.getMachineHandler().setStackInSlot(0, fuelStack.getCraftingRemainingItem());
        } else {
            fuelStack.shrink(1);
        }
        this.feRemaining = burnTime * this.getFePerFuelTick();
        this.maxBurn = (int)(Math.floor(burnTime) / (double)this.getBurnSpeedMultiplier());
        this.burnRemaining = this.maxBurn + 1;
    }

    public void doGenerate() {
        if (this.isActiveRedstone() && this.feRemaining == 0) {
            this.doBurn();
        }
        if (this.feRemaining == 0) {
            return;
        }
        int insertAmt = Math.min(this.fePerTick(), this.feRemaining);
        this.insertEnergy(insertAmt, false);
        this.feRemaining -= insertAmt;
        --this.burnRemaining;
        if (this.isActiveRedstone() && this.feRemaining == 0) {
            this.doBurn();
            if (insertAmt < this.fePerTick()) {
                int newInsertAmt = Math.min(this.fePerTick() - insertAmt, this.feRemaining);
                this.insertEnergy(newInsertAmt, false);
                this.feRemaining -= newInsertAmt;
                --this.burnRemaining;
            }
        }
        this.setChanged();
    }

    @Override
    public void handleTicks() {
    }

    @Override
    public boolean canRun() {
        return true;
    }

    public int fePerTick() {
        return this.getFePerFuelTick() * this.getBurnSpeedMultiplier();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.GENERATOR_T1_MAX_FE.get();
    }

    public int getFEPerTick() {
        return (Integer)Config.GENERATOR_T1_FE_PER_TICK.get();
    }

    public int getFePerFuelTick() {
        return (Integer)Config.GENERATOR_T1_FE_PER_FUEL_TICK.get();
    }

    public int getBurnSpeedMultiplier() {
        return (Integer)Config.GENERATOR_T1_BURN_SPEED_MULTIPLIER.get() * this.fuelBurnMultiplier;
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.burnRemaining != 0) {
            return false;
        }
        if (this.maxBurn != 0) {
            return false;
        }
        return this.feRemaining == 0;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("burnRemaining", this.burnRemaining);
        tag.putInt("maxBurn", this.maxBurn);
        tag.putInt("feRemaining", this.feRemaining);
        tag.putInt("fuelBurnMultiplier", this.fuelBurnMultiplier);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.burnRemaining = tag.getInt("burnRemaining");
        this.maxBurn = tag.getInt("maxBurn");
        this.feRemaining = tag.getInt("feRemaining");
        if (tag.contains("fuelBurnMultiplier")) {
            this.fuelBurnMultiplier = tag.getInt("fuelBurnMultiplier");
        }
    }
}

