/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.SensorT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SensorT2BE
extends SensorT1BE
implements AreaAffectingBE,
PoweredMachineBE {
    public AreaAffectingData areaAffectingData = new AreaAffectingData();
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData(this);

    public SensorT2BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public SensorT2BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.SensorT2BE.get(), pPos, pBlockState);
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 2;
    }

    public int getEnergyCost() {
        AABB aabb = this.getAABB(this.getBlockPos());
        int width = (int)Math.abs(Math.floor(aabb.maxX) - Math.floor(aabb.minX));
        int height = (int)Math.abs(Math.floor(aabb.maxY) - Math.floor(aabb.minY));
        int depth = (int)Math.abs(Math.floor(aabb.maxZ) - Math.floor(aabb.minZ));
        return width * height * depth * this.getStandardEnergyCost();
    }

    @Override
    public boolean canSense() {
        int cost = this.getEnergyCost();
        return this.extractEnergy(cost, false) >= cost;
    }

    @Override
    public List<Entity> findEntities(AABB aabb) {
        ArrayList<Entity> returnList = new ArrayList<Entity>(this.level.getEntitiesOfClass(Entity.class, this.getAABB(this.getBlockPos()), this::isValidEntity));
        return returnList;
    }

    @Override
    public AABB getAABB() {
        return this.getAABB(this.getBlockPos());
    }

    @Override
    public List<BlockPos> findPositions() {
        AABB area = this.getAABB(this.getBlockPos());
        return BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).filter(this::isBlockPosValid).map(BlockPos::immutable).sorted(Comparator.comparingDouble(x -> x.distSqr((Vec3i)this.getBlockPos()))).collect(Collectors.toList());
    }

    @Override
    public boolean isDefaultSettings() {
        return super.isDefaultSettings();
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("senseTarget", this.sense_target.ordinal());
        tag.putBoolean("strongSignal", this.strongSignal);
        tag.put("blockStateProps", (Tag)this.saveBlockStateProperties());
    }

    @Override
    public void load(CompoundTag tag) {
        this.sense_target = SensorT1BE.SENSE_TARGET.values()[tag.getInt("senseTarget")];
        this.strongSignal = tag.getBoolean("strongSignal");
        super.load(tag);
        this.loadBlockStateProperties(tag.getCompound("blockStateProps"));
    }
}

