/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public interface AreaAffectingBE {
    public static final double maxRadius = 5.0;
    public static final int maxOffset = 9;

    public BlockEntity getBlockEntity();

    public AreaAffectingData getAreaAffectingData();

    default public AABB getAABBOffsetOnly(BlockPos relativePos) {
        double xOffset = this.getAreaAffectingData().xOffset;
        double yOffset = this.getAreaAffectingData().yOffset;
        double zOffset = this.getAreaAffectingData().zOffset;
        if (this.getAreaAffectingData().xRadius != Math.floor(this.getAreaAffectingData().xRadius)) {
            xOffset += 0.75;
        }
        if (this.getAreaAffectingData().yRadius != Math.floor(this.getAreaAffectingData().yRadius)) {
            yOffset += 0.75;
        }
        if (this.getAreaAffectingData().zRadius != Math.floor(this.getAreaAffectingData().zRadius)) {
            zOffset += 0.75;
        }
        return new AABB((double)relativePos.getX() + xOffset, (double)relativePos.getY() + yOffset, (double)relativePos.getZ() + zOffset, (double)relativePos.getX() + xOffset + (this.getAreaAffectingData().xRadius != Math.floor(this.getAreaAffectingData().xRadius) ? 0.5 : 1.0), (double)relativePos.getY() + yOffset + (this.getAreaAffectingData().yRadius != Math.floor(this.getAreaAffectingData().yRadius) ? 0.5 : 1.0), (double)relativePos.getZ() + zOffset + (this.getAreaAffectingData().zRadius != Math.floor(this.getAreaAffectingData().zRadius) ? 0.5 : 1.0));
    }

    default public AABB getAABB(BlockPos relativePos) {
        if (this.getAreaAffectingData().area == null) {
            double xOffset = this.getAreaAffectingData().xOffset;
            double yOffset = this.getAreaAffectingData().yOffset;
            double zOffset = this.getAreaAffectingData().zOffset;
            if (this.getAreaAffectingData().xRadius != Math.floor(this.getAreaAffectingData().xRadius)) {
                xOffset += 0.5;
            }
            if (this.getAreaAffectingData().yRadius != Math.floor(this.getAreaAffectingData().yRadius)) {
                yOffset += 0.5;
            }
            if (this.getAreaAffectingData().zRadius != Math.floor(this.getAreaAffectingData().zRadius)) {
                zOffset += 0.5;
            }
            this.getAreaAffectingData().area = new AABB((double)relativePos.getX() + xOffset, (double)relativePos.getY() + yOffset, (double)relativePos.getZ() + zOffset, (double)relativePos.getX() + xOffset + 1.0, (double)relativePos.getY() + yOffset + 1.0, (double)relativePos.getZ() + zOffset + 1.0).inflate(this.getAreaAffectingData().xRadius, this.getAreaAffectingData().yRadius, this.getAreaAffectingData().zRadius);
        }
        return this.getAreaAffectingData().area;
    }

    default public void setAreaSettings(double x, double y, double z, int xo, int yo, int zo, boolean renderArea) {
        this.getAreaAffectingData().xRadius = Math.max(0.0, Math.min(x, 5.0));
        this.getAreaAffectingData().yRadius = Math.max(0.0, Math.min(y, 5.0));
        this.getAreaAffectingData().zRadius = Math.max(0.0, Math.min(z, 5.0));
        this.getAreaAffectingData().xOffset = Math.max(-9, Math.min(xo, 9));
        this.getAreaAffectingData().yOffset = Math.max(-9, Math.min(yo, 9));
        this.getAreaAffectingData().zOffset = Math.max(-9, Math.min(zo, 9));
        this.getAreaAffectingData().renderArea = renderArea;
        this.getAreaAffectingData().area = null;
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            baseMachineBE.markDirtyClient();
        }
    }

    default public void saveAreaSettings(CompoundTag tag) {
        tag.putDouble("xRadiusDouble", this.getAreaAffectingData().xRadius);
        tag.putDouble("yRadiusDouble", this.getAreaAffectingData().yRadius);
        tag.putDouble("zRadiusDouble", this.getAreaAffectingData().zRadius);
        tag.putInt("xOffset", this.getAreaAffectingData().xOffset);
        tag.putInt("yOffset", this.getAreaAffectingData().yOffset);
        tag.putInt("zOffset", this.getAreaAffectingData().zOffset);
        tag.putBoolean("renderArea", this.getAreaAffectingData().renderArea);
    }

    default public void loadAreaSettings(CompoundTag tag) {
        if (tag.contains("xRadius")) {
            this.getAreaAffectingData().xRadius = tag.getInt("xRadius");
            this.getAreaAffectingData().yRadius = tag.getInt("yRadius");
            this.getAreaAffectingData().zRadius = tag.getInt("zRadius");
            this.getAreaAffectingData().xOffset = tag.getInt("xOffset");
            this.getAreaAffectingData().yOffset = tag.getInt("yOffset");
            this.getAreaAffectingData().zOffset = tag.getInt("zOffset");
            this.getAreaAffectingData().renderArea = tag.getBoolean("renderArea");
        }
        if (tag.contains("xRadiusDouble")) {
            this.getAreaAffectingData().xRadius = tag.getDouble("xRadiusDouble");
            this.getAreaAffectingData().yRadius = tag.getDouble("yRadiusDouble");
            this.getAreaAffectingData().zRadius = tag.getDouble("zRadiusDouble");
            this.getAreaAffectingData().xOffset = tag.getInt("xOffset");
            this.getAreaAffectingData().yOffset = tag.getInt("yOffset");
            this.getAreaAffectingData().zOffset = tag.getInt("zOffset");
            this.getAreaAffectingData().renderArea = tag.getBoolean("renderArea");
        }
    }
}

