/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities.basebe;

import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BaseMachineBE
extends BlockEntity {
    public int MACHINE_SLOTS = 0;
    public int ANYSIZE_FILTER_SLOTS = 0;
    public static final UUID defaultFakePlayerUUID = UUID.fromString("4191a6f5-37fe-45d9-8ba3-4549be778e54");
    public static final GameProfile defaultFakePlayerProfile = new GameProfile(defaultFakePlayerUUID, "[JustDiresFakePlayer]");
    public UUID placedByUUID;
    protected int direction = 0;
    protected int tickSpeed = 20;
    protected int operationTicks = -1;
    protected UsefulFakePlayer usefulFakePlayer;

    public BaseMachineBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void tickClient() {
    }

    public void tickServer() {
        this.handleTicks();
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE);
            redstoneControlledBE.evaluateRedstone();
        }
    }

    public void handleTicks() {
        if (this.operationTicks <= 0) {
            this.operationTicks = this.tickSpeed;
        }
        --this.operationTicks;
    }

    public int getTickSpeed() {
        return this.tickSpeed;
    }

    public void setTickSpeed(int newTickSpeed) {
        this.tickSpeed = newTickSpeed;
        if (this.operationTicks > this.tickSpeed) {
            this.operationTicks = this.tickSpeed;
        }
        this.markDirtyClient();
    }

    public boolean canRun() {
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE);
            return this.operationTicks == 0 || redstoneControlledBE.getRedstoneControlData().redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
        }
        return this.operationTicks == 0;
    }

    public int getDirection() {
        return this.direction;
    }

    public Direction getDirectionValue() {
        return Direction.values()[this.direction];
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    protected GameProfile getPlacedByProfile() {
        if (this.placedByUUID == null) {
            return defaultFakePlayerProfile;
        }
        return new GameProfile(this.placedByUUID, "[JustDiresFakePlayer]");
    }

    protected FakePlayer getFakePlayer(ServerLevel level) {
        return FakePlayerFactory.get((ServerLevel)level, (GameProfile)this.getPlacedByProfile());
    }

    protected FakePlayer getFakePlayer(ServerLevel level, UUID uuid) {
        GameProfile gameProfile = new GameProfile(uuid, "[JustDiresFakePlayer]");
        return FakePlayerFactory.get((ServerLevel)level, (GameProfile)gameProfile);
    }

    protected UsefulFakePlayer getUsefulFakePlayer(ServerLevel level) {
        if (this.usefulFakePlayer == null) {
            this.usefulFakePlayer = UsefulFakePlayer.createPlayer((Level)level, this.getPlacedByProfile());
        }
        return this.usefulFakePlayer;
    }

    public void setFakePlayerData(ItemStack itemStack, FakePlayer fakePlayer, BlockPos blockPos, Direction direction) {
        fakePlayer.setPos((double)blockPos.below().relative(direction).getX() + 0.5, (double)blockPos.below().relative(direction).getY(), (double)blockPos.below().relative(direction).getZ() + 0.5);
        float xRot = direction == Direction.DOWN ? 90.0f : (direction == Direction.UP ? -90.0f : 0.0f);
        fakePlayer.setXRot(xRot);
        fakePlayer.setYRot(direction.toYRot());
        fakePlayer.setYHeadRot(direction.toYRot());
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
    }

    public void setPlacedBy(UUID placedBy) {
        this.placedByUUID = placedBy;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStackHandler getMachineHandler() {
        return (ItemStackHandler)this.getData(Registration.MACHINE_HANDLER);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof AreaAffectingBE) {
            AreaAffectingBE areaAffectingBE = (AreaAffectingBE)((Object)baseMachineBE);
            areaAffectingBE.getAreaAffectingData().area = null;
        }
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void setChanged() {
        super.setChanged();
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            filterableBE.getFilterData().filterCache.clear();
        }
    }

    public AreaAffectingData getDefaultAreaData() {
        return new AreaAffectingData();
    }

    public FilterData getDefaultFilterData() {
        return new FilterData();
    }

    public RedstoneControlData getDefaultRedstoneData() {
        return new RedstoneControlData();
    }

    public boolean isDefaultSettings() {
        RedstoneControlledBE redstoneControlledBE;
        PoweredMachineBE poweredMachineBE;
        FilterableBE filterableBE;
        AreaAffectingBE areaAffectingBE;
        if (this.tickSpeed != 20) {
            return false;
        }
        if (this.direction != 0) {
            return false;
        }
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof AreaAffectingBE && !(areaAffectingBE = (AreaAffectingBE)((Object)baseMachineBE)).getAreaAffectingData().equals(this.getDefaultAreaData())) {
            return false;
        }
        baseMachineBE = this;
        if (baseMachineBE instanceof FilterableBE && !(filterableBE = (FilterableBE)((Object)baseMachineBE)).getFilterData().equals(this.getDefaultFilterData())) {
            return false;
        }
        baseMachineBE = this;
        if (baseMachineBE instanceof FilterableBE) {
            filterableBE = (FilterableBE)((Object)baseMachineBE);
            FilterBasicHandler filteredItems = filterableBE.getFilterHandler();
            for (int i = 0; i < filteredItems.getSlots(); ++i) {
                if (filteredItems.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
        }
        if ((baseMachineBE = this) instanceof PoweredMachineBE && (poweredMachineBE = (PoweredMachineBE)((Object)baseMachineBE)).getEnergyStored() > 0) {
            return false;
        }
        baseMachineBE = this;
        return !(baseMachineBE instanceof RedstoneControlledBE) || (redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE)).getRedstoneControlData().equals(this.getDefaultRedstoneData());
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("tickspeed", this.tickSpeed);
        if (this.placedByUUID != null) {
            tag.putUUID("placedBy", this.placedByUUID);
        }
        tag.putInt("direction", this.direction);
        BaseMachineBE baseMachineBE = this;
        if (baseMachineBE instanceof AreaAffectingBE) {
            AreaAffectingBE areaAffectingBE = (AreaAffectingBE)((Object)baseMachineBE);
            areaAffectingBE.saveAreaSettings(tag);
        }
        if ((baseMachineBE = this) instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            filterableBE.saveFilterSettings(tag);
        }
        if ((baseMachineBE = this) instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE);
            redstoneControlledBE.saveRedstoneSettings(tag);
        }
    }

    public void load(CompoundTag tag) {
        BaseMachineBE baseMachineBE;
        if (tag.contains("direction")) {
            this.direction = tag.getInt("direction");
        }
        if (tag.contains("tickspeed")) {
            this.tickSpeed = tag.getInt("tickspeed");
        }
        if (tag.contains("placedBy")) {
            this.placedByUUID = tag.getUUID("placedBy");
        }
        if ((baseMachineBE = this) instanceof AreaAffectingBE) {
            AreaAffectingBE areaAffectingBE = (AreaAffectingBE)((Object)baseMachineBE);
            areaAffectingBE.loadAreaSettings(tag);
        }
        if ((baseMachineBE = this) instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            filterableBE.loadFilterSettings(tag);
        }
        if ((baseMachineBE = this) instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE);
            redstoneControlledBE.loadRedstoneSettings(tag);
        }
        super.load(tag);
    }
}

