/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks;

import com.direwolf20.justdirethings.common.blockentities.EclipseGateBE;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EclipseGateBlock
extends Block
implements EntityBlock {
    public EclipseGateBlock() {
        super(BlockBehaviour.Properties.of().strength(20.0f).noOcclusion().noCollission().forceSolidOn().isSuffocating(BaseMachineBlock::never).isViewBlocking(BaseMachineBlock::never).pushReaction(PushReaction.BLOCK));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof EclipseGateBE) {
                    EclipseGateBE tile = (EclipseGateBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof EclipseGateBE) {
                EclipseGateBE tile = (EclipseGateBE)t;
                tile.tickServer();
            }
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EclipseGateBE(pos, state);
    }

    public boolean propagatesSkylightDown(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public float getShadeBrightness(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }
}

