/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blocks.baseblocks;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineBlock
extends Block
implements EntityBlock {
    public BaseMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BaseMachineBE) {
                CompoundTag compound;
                BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
                CompoundTag tag = stack.getTag();
                if (tag != null && !(compound = stack.getTag().getCompound("JustDiresBEData")).isEmpty()) {
                    blockEntity.load(compound);
                }
                baseMachineBE.setPlacedBy(player.getUUID());
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof BaseMachineBE) {
                    BaseMachineBE tile = (BaseMachineBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof BaseMachineBE) {
                BaseMachineBE tile = (BaseMachineBE)t;
                tile.tickServer();
            }
        };
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(blockState, level, pos, blockIn, fromPos, isMoving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)blockEntity;
            redstoneControlledBE.getRedstoneControlData().checkedRedstone = false;
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @javax.annotation.Nullable Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneControlledBE) {
            return true;
        }
        return super.canConnectRedstone(state, level, pos, direction);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.getBlock() != this && (blockEntity = worldIn.getBlockEntity(pos)) instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE = (BaseMachineBE)blockEntity;
            ItemStackHandler iItemHandler = baseMachineBE.getMachineHandler();
            for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)iItemHandler.getStackInSlot(i));
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BaseMachineBE baseMachineBE;
        List drops = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof BaseMachineBE && !(baseMachineBE = (BaseMachineBE)blockEntity).isDefaultSettings()) {
            ItemStack itemStack = new ItemStack((ItemLike)Item.byBlock((Block)this));
            CompoundTag compoundTag = new CompoundTag();
            ((BaseMachineBE)blockEntity).saveAdditional(compoundTag);
            if (!compoundTag.isEmpty()) {
                itemStack.getOrCreateTag().put("JustDiresBEData", (Tag)compoundTag);
            }
            drops.clear();
            drops.add(itemStack);
        }
        return drops;
    }
}

