/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.capabilities;

import com.direwolf20.justdirethings.common.blockentities.EnergyTransmitterBE;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;

public class TransmitterEnergyStorage
extends MachineEnergyStorage {
    private final EnergyTransmitterBE energyTransmitterBE;

    public TransmitterEnergyStorage(int capacity, EnergyTransmitterBE energyTransmitterBE) {
        super(capacity);
        this.energyTransmitterBE = energyTransmitterBE;
    }

    @Override
    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energyTransmitterBE.distributeEnergy(energyReceived);
        }
        return energyReceived;
    }

    public int realReceiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int realExtractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energyTransmitterBE.getTotalEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyTransmitterBE.getTotalMaxEnergyStored();
    }

    public int getRealEnergyStored() {
        return this.energy;
    }

    public int getRealMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public Tag serializeNBT() {
        return IntTag.valueOf((int)this.getRealEnergyStored());
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.energy = intNbt.getAsInt();
    }
}

