/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers;

import com.direwolf20.justdirethings.common.containers.basecontainers.BaseContainer;
import com.direwolf20.justdirethings.common.containers.handlers.FuelCanisterHandler;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class FuelCanisterContainer
extends BaseContainer {
    public static final int SLOTS = 1;
    public FuelCanisterHandler handler;
    public ItemStack fuelCanisterItemstack;
    public Player playerEntity;

    public FuelCanisterContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player, extraData.readItem());
    }

    public FuelCanisterContainer(int windowId, Inventory playerInventory, Player player, ItemStack fuelCanister) {
        super((MenuType)Registration.FuelCanister_Container.get(), windowId);
        this.playerEntity = player;
        this.handler = new FuelCanisterHandler(1, fuelCanister);
        this.fuelCanisterItemstack = fuelCanister;
        if (this.handler != null) {
            this.addSlotRange((IItemHandler)this.handler, 0, 80, 35, 1, 18);
        }
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.getMainHandItem().equals(this.fuelCanisterItemstack);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            if (index < 1 && !this.moveItemStackTo(currentStack, 1, 37, true)) {
                return ItemStack.EMPTY;
            }
            if (index >= 1 && !this.moveItemStackTo(currentStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (currentStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, currentStack);
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        ItemStack containerItem;
        Level world = playerIn.level();
        if (!world.isClientSide && !(containerItem = this.handler.getStackInSlot(0)).isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)containerItem);
        }
        super.removed(playerIn);
    }
}

