/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers.basecontainers;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.containers.basecontainers.BaseContainer;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.containers.slots.FilterBasicSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineContainer
extends BaseContainer {
    public int FILTER_SLOTS = 0;
    public int MACHINE_SLOTS = 0;
    public BaseMachineBE baseMachineBE;
    public FilterBasicHandler filterHandler;
    public ItemStackHandler machineHandler;
    protected Player player;
    protected BlockPos pos;
    public ContainerData data;

    public BaseMachineContainer(@Nullable MenuType<?> menuType, int windowId, Inventory playerInventory, BlockPos blockPos) {
        super(menuType, windowId);
        this.pos = blockPos;
        this.player = playerInventory.player;
        BlockEntity blockEntity = this.player.level().getBlockEntity(this.pos);
        if (blockEntity instanceof BaseMachineBE) {
            BaseMachineBE baseMachineBE;
            this.baseMachineBE = baseMachineBE = (BaseMachineBE)blockEntity;
            this.MACHINE_SLOTS = baseMachineBE.MACHINE_SLOTS;
        }
        if (this.MACHINE_SLOTS > 0) {
            this.addMachineSlots();
        }
        if (blockEntity instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)blockEntity;
            this.filterHandler = filterableBE.getFilterHandler();
            this.FILTER_SLOTS = this.filterHandler.getSlots();
            this.addFilterSlots();
        }
        if (blockEntity instanceof PoweredMachineBE) {
            PoweredMachineBE poweredMachineBE = (PoweredMachineBE)blockEntity;
            this.data = poweredMachineBE.getContainerData();
            this.addDataSlots(this.data);
        }
    }

    public void addFilterSlots() {
        this.addFilterSlots((IItemHandler)this.filterHandler, 0, 8, 54, this.FILTER_SLOTS, 18);
    }

    public void addMachineSlots() {
        this.machineHandler = this.baseMachineBE.getMachineHandler();
        this.addSlotRange((IItemHandler)this.machineHandler, 0, 80, 35, this.MACHINE_SLOTS, 18);
    }

    public int getEnergy() {
        return this.data == null ? 0 : this.data.get(1) << 16 | this.data.get(0);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (this.baseMachineBE instanceof FilterableBE && slotId >= this.MACHINE_SLOTS && slotId < this.FILTER_SLOTS) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack currentStack;
        Slot slot;
        ItemStack itemstack = ItemStack.EMPTY;
        if (this.MACHINE_SLOTS > 0 && (slot = (Slot)this.slots.get(index)).hasItem()) {
            currentStack = slot.getItem();
            if (index < this.MACHINE_SLOTS && !this.moveItemStackTo(currentStack, this.MACHINE_SLOTS + this.FILTER_SLOTS, this.MACHINE_SLOTS + this.FILTER_SLOTS + 36, true)) {
                return ItemStack.EMPTY;
            }
            if (index < this.MACHINE_SLOTS + this.FILTER_SLOTS || !this.moveItemStackTo(currentStack, 0, this.MACHINE_SLOTS, false)) {
                // empty if block
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (currentStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, currentStack);
        }
        if (this.baseMachineBE instanceof FilterableBE && (slot = (Slot)this.slots.get(index)).hasItem() && index >= this.MACHINE_SLOTS + this.FILTER_SLOTS) {
            currentStack = slot.getItem().copy();
            currentStack.setCount(1);
            return this.quickMoveBasicFilter(currentStack, this.MACHINE_SLOTS, this.FILTER_SLOTS);
        }
        return itemstack;
    }

    protected int addFilterSlots(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (handler instanceof FilterBasicHandler) {
                this.addSlot((Slot)new FilterBasicSlot(handler, index, x, y));
            } else {
                this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }
}

