/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.common.items.TotemOfDeathRecall;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class LivingEntityEvents {
    @SubscribeEvent
    public static void blockJoin(EntityJoinLevelEvent e) {
        if (e.getEntity() instanceof UsefulFakePlayer) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void LivingFallDamage(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ToggleableTool toggleableTool;
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack heldItem = player.getMainHandItem();
            Item item = heldItem.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.AIRBURST)) {
                event.setDistance(0.0f);
                return;
            }
            heldItem = player.getOffhandItem();
            item = heldItem.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).hasAbility(Ability.AIRBURST)) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void LivingDropsEvent(LivingDropsEvent event) {
        Player player;
        ItemStack mainHand;
        Item item;
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player && (item = (mainHand = (player = (Player)entity).getMainHandItem()).getItem()) instanceof ToggleableTool) {
            IItemHandler handler;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (toggleableTool.canUseAbility(mainHand, Ability.SMOKER)) {
                for (ItemEntity itemEntity : event.getDrops()) {
                    boolean[] dropSmoked = new boolean[1];
                    Helpers.smokeDrop((ServerLevel)player.level(), itemEntity, mainHand, event.getEntity(), dropSmoked);
                    if (!dropSmoked[0]) continue;
                    ToggleableTool.smokerParticles((ServerLevel)player.level(), itemEntity.blockPosition(), itemEntity.getItem().getCount());
                }
            }
            if (toggleableTool.canUseAbility(mainHand, Ability.DROPTELEPORT) && (handler = ToggleableTool.getBoundHandler((ServerLevel)player.level(), mainHand)) != null) {
                Iterator iterator = event.getDrops().iterator();
                while (iterator.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iterator.next();
                    ItemStack stack = itemEntity.getItem();
                    ItemStack leftover = Helpers.teleportDrop(stack, handler, mainHand, player);
                    if (leftover.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    itemEntity.setItem(leftover);
                }
                if (event.getDrops().isEmpty()) {
                    ToggleableTool.teleportParticles((ServerLevel)player.level(), event.getEntity().getPosition(0.0f));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        ItemStack totemStack;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && !(totemStack = LivingEntityEvents.findTotem(player = (ServerPlayer)livingEntity)).isEmpty()) {
            CompoundTag deathData = new CompoundTag();
            deathData.put("direDeathData", (Tag)NBTHelpers.globalVec3ToNBT((ResourceKey<Level>)player.level().dimension(), player.position()));
            player.setData(Registration.DEATH_DATA, (Object)deathData);
            totemStack.shrink(1);
        }
    }

    private static ItemStack findTotem(ServerPlayer player) {
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != Registration.TotemOfDeathRecall.get() || TotemOfDeathRecall.getBoundTo(itemStack) != null) continue;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        ServerPlayer oldPlayer = (ServerPlayer)event.getOriginal();
        if (oldPlayer.level().isClientSide || !event.isWasDeath()) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        CompoundTag deathData = (CompoundTag)oldPlayer.getData(Registration.DEATH_DATA);
        if (deathData.contains("direDeathData")) {
            NBTHelpers.GlobalVec3 boundTo = NBTHelpers.nbtToGlobalVec3(deathData.getCompound("direDeathData"));
            ItemStack totemStack = new ItemStack((ItemLike)Registration.TotemOfDeathRecall.get());
            TotemOfDeathRecall.setBoundTo(totemStack, boundTo);
            newPlayer.getInventory().add(totemStack);
        }
    }
}

