/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.blockentities.BlockSwapperT1BE;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FerricoreWrench
extends Item {
    public FerricoreWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = player.getItemInHand(context.getHand());
        BlockState state = level.getBlockState(pos);
        if (!player.isShiftKeyDown() && this.specialBlockHandling(level, player, pos, state, itemstack)) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            for (Property prop : state.getProperties()) {
                if (!(prop instanceof DirectionProperty) || !prop.getName().equals("facing")) continue;
                BlockState rotatedState = this.rotateBlock(state, (DirectionProperty)prop, state.getValue(prop));
                level.setBlock(pos, rotatedState, 3);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean specialBlockHandling(Level level, Player player, BlockPos blockPos, BlockState blockState, ItemStack itemStack) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BlockSwapperT1BE) {
            BlockSwapperT1BE blockSwapperT1BE = (BlockSwapperT1BE)blockEntity;
            GlobalPos boundPos = FerricoreWrench.getBoundTo(itemStack);
            if (boundPos == null) {
                GlobalPos newBind = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)blockPos);
                FerricoreWrench.setBoundTo(itemStack, newBind);
                player.displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)newBind.dimension().location().getPath()), "[" + newBind.pos().toShortString() + "]"}), true);
                player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                boolean bound = blockSwapperT1BE.handleConnection(boundPos);
                if (bound) {
                    player.displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)boundPos.dimension().location().getPath()), "[" + boundPos.pos().toShortString() + "]"}), true);
                    player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"justdirethings.bindremoved"), true);
                    player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                FerricoreWrench.removeBoundTo(itemStack);
            }
            return true;
        }
        return false;
    }

    public boolean isFoil(ItemStack pStack) {
        return FerricoreWrench.getBoundTo(pStack) != null;
    }

    private BlockState rotateBlock(BlockState state, DirectionProperty prop, Comparable<?> currentValue) {
        List directions = prop.getPossibleValues().stream().toList();
        int currentDirectionIndex = directions.indexOf(currentValue);
        int nextDirectionIndex = (currentDirectionIndex + 1) % directions.size();
        Direction nextDirection = (Direction)directions.get(nextDirectionIndex);
        return (BlockState)state.setValue((Property)prop, (Comparable)nextDirection);
    }

    public static GlobalPos getBoundTo(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag != null && tag.contains("boundTo") ? NBTHelpers.nbtToGlobalPos(tag.getCompound("boundTo")) : null;
    }

    public static void setBoundTo(ItemStack stack, GlobalPos globalPos) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.put("boundTo", (Tag)NBTHelpers.globalPosToNBT(globalPos));
    }

    public static void removeBoundTo(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.remove("boundTo");
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        GlobalPos boundPos = FerricoreWrench.getBoundTo(stack);
        ChatFormatting chatFormatting = ChatFormatting.DARK_PURPLE;
        if (boundPos != null) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{I18n.get((String)boundPos.dimension().location().getPath(), (Object[])new Object[0]), boundPos.pos().toShortString()}).withStyle(chatFormatting));
        }
    }
}

