/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TotemOfDeathRecall
extends Item {
    public TotemOfDeathRecall() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (TotemOfDeathRecall.getBoundTo(itemStack) == null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            CompoundTag tag;
            Player player = (Player)entityLiving;
            int usedDuration = this.getUseDuration(stack) - timeLeft;
            if (usedDuration >= 20 && !world.isClientSide && (tag = stack.getTag()) != null) {
                NBTHelpers.GlobalVec3 globalPos = TotemOfDeathRecall.getBoundTo(stack);
                if (globalPos == null) {
                    return;
                }
                Vec3 position = globalPos.position();
                ServerLevel targetLevel = world.getServer().getLevel(globalPos.dimension());
                if (targetLevel != null) {
                    player.teleportTo(targetLevel, position.x(), position.y(), position.z(), new HashSet(), player.getYRot(), player.getXRot());
                    stack.shrink(1);
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    public boolean isFoil(ItemStack pStack) {
        return TotemOfDeathRecall.getBoundTo(pStack) != null;
    }

    public static NBTHelpers.GlobalVec3 getBoundTo(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        return tag != null && tag.contains("boundTo") ? NBTHelpers.nbtToGlobalVec3(tag.getCompound("boundTo")) : null;
    }

    public static void setBoundTo(ItemStack stack, NBTHelpers.GlobalVec3 globalPos) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.put("boundTo", (Tag)NBTHelpers.globalVec3ToNBT(globalPos));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        NBTHelpers.GlobalVec3 boundPos = TotemOfDeathRecall.getBoundTo(stack);
        ChatFormatting chatFormatting = ChatFormatting.DARK_PURPLE;
        if (boundPos != null) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{I18n.get((String)boundPos.dimension().location().getPath(), (Object[])new Object[0]), boundPos.toVec3ShortString()}).withStyle(chatFormatting));
        }
    }
}

