/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public enum Ability {
    MOBSCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, AbilityMethods::scanForMobScanner, false),
    OREMINER(SettingType.TOGGLE, 1, 50),
    ORESCANNER(SettingType.TOGGLE, 10, 500, UseType.USE, AbilityMethods::scanForOreScanner, false),
    LAWNMOWER(SettingType.TOGGLE, 1, 50, UseType.USE, AbilityMethods::lawnmower, false),
    SKYSWEEPER(SettingType.TOGGLE, 1, 50),
    TREEFELLER(SettingType.TOGGLE, 1, 50),
    LEAFBREAKER(SettingType.TOGGLE, 1, 50, UseType.USE_ON, AbilityMethods::leafbreaker, false),
    SMELTER(SettingType.TOGGLE, 1, 50),
    SMOKER(SettingType.TOGGLE, 1, 50),
    HAMMER(SettingType.CYCLE, 1, 50),
    LAVAREPAIR(SettingType.TOGGLE, 0, 0),
    CAUTERIZEWOUNDS(SettingType.TOGGLE, 30, 1500, UseType.USE, AbilityMethods::cauterizeWounds, false),
    AIRBURST(SettingType.SLIDER, 1, 250, UseType.USE, AbilityMethods::airBurst, false),
    DROPTELEPORT(SettingType.TOGGLE, 2, 100),
    VOIDSHIFT(SettingType.SLIDER, 1, 50, UseType.USE, AbilityMethods::voidShift, true),
    OREXRAY(SettingType.TOGGLE, 100, 5000, UseType.USE, AbilityMethods::scanForOreXRAY, false),
    GLOWING(SettingType.TOGGLE, 100, 5000, UseType.USE, AbilityMethods::glowing, false),
    INSTABREAK(SettingType.TOGGLE, 2, 250),
    ECLIPSEGATE(SettingType.TOGGLE, 1, 250, UseType.USE_ON, AbilityMethods::eclipseGate, false);

    final String name = this.name().toLowerCase(Locale.ROOT);
    final String localization;
    final SettingType settingType;
    final ResourceLocation iconLocation;
    final int durabilityCost;
    final int feCost;
    final boolean bindable;
    final boolean renderButton;
    UseType useType;
    private static final Map<Ability, AbilityParams> dynamicParams;
    public AbilityAction action;
    public UseOnAbilityAction useOnAction;

    private Ability(SettingType settingType, int durabilityCost, int feCost, boolean bindable, boolean renderButton) {
        this.settingType = settingType;
        this.localization = "justdirethings.ability." + this.name;
        this.iconLocation = new ResourceLocation("justdirethings", "textures/gui/buttons/" + this.name + ".png");
        this.durabilityCost = durabilityCost;
        this.feCost = feCost;
        this.bindable = bindable;
        this.renderButton = renderButton;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost) {
        this(settingType, durabilityCost, feCost, false, false);
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, AbilityAction action, boolean renderButton) {
        this(settingType, durabilityCost, feCost, true, renderButton);
        this.action = action;
        this.useType = useType;
    }

    private Ability(SettingType settingType, int durabilityCost, int feCost, UseType useType, UseOnAbilityAction useOnAction, boolean renderButton) {
        this(settingType, durabilityCost, feCost, true, renderButton);
        this.useOnAction = useOnAction;
        this.useType = useType;
    }

    public boolean hasDynamicParams(Ability toolAbility) {
        return dynamicParams.containsKey((Object)toolAbility);
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getName() {
        return this.name;
    }

    public SettingType getSettingType() {
        return this.settingType;
    }

    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public int getFeCost() {
        return this.feCost;
    }

    public boolean isBindable() {
        return this.bindable;
    }

    public boolean hasRenderButton() {
        return this.renderButton;
    }

    static {
        dynamicParams = new EnumMap<Ability, AbilityParams>(Ability.class);
    }

    public static enum SettingType {
        TOGGLE,
        SLIDER,
        CYCLE;

    }

    @FunctionalInterface
    public static interface AbilityAction {
        public boolean execute(Level var1, Player var2, ItemStack var3);
    }

    public static enum UseType {
        USE,
        USE_ON;

    }

    @FunctionalInterface
    public static interface UseOnAbilityAction {
        public boolean execute(UseOnContext var1);
    }
}

