/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class BaseToggleableTool
extends Item
implements ToggleableTool {
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);

    public BaseToggleableTool(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public EnumSet<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (this.bindDrops(pContext)) {
            return InteractionResult.SUCCESS;
        }
        if (this.useOnAbility(pContext)) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown()) {
            this.openSettings(player);
        }
        this.useAbility(level, player, hand);
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        TooltipHelpers.appendFEText(stack, tooltip);
        if (sneakPressed) {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendAbilityList(stack, tooltip);
        } else {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendShiftForInfo(stack, tooltip);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (stack.getItem() instanceof PoweredItem) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return amount;
            }
            int unbreakingLevel = stack.getEnchantmentLevel(Enchantments.UNBREAKING);
            double reductionFactor = Math.min(1.0, (double)unbreakingLevel * 0.1);
            int finalEnergyCost = (int)Math.max(0.0, (double)amount - (double)amount * reductionFactor);
            energyStorage.extractEnergy(finalEnergyCost, false);
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (stack.getItem() instanceof PoweredItem) {
            return super.isBookEnchantable(stack, book) && this.canAcceptEnchantments(book);
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.getItem() instanceof PoweredItem) {
            return super.canApplyAtEnchantingTable(stack, enchantment) && this.canAcceptEnchantments(enchantment);
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private boolean canAcceptEnchantments(ItemStack book) {
        return !EnchantmentHelper.getEnchantments((ItemStack)book).containsKey(Enchantments.MENDING);
    }

    private boolean canAcceptEnchantments(Enchantment enchantment) {
        return enchantment != Enchantments.MENDING;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return super.getUseAnimation(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (this.canUseAbility(stack, Ability.LAVAREPAIR)) {
            return Helpers.doLavaRepair(stack, entity);
        }
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            return poweredItem.isPowerBarVisible(stack);
        }
        return super.isBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            return poweredItem.getPowerBarWidth(stack);
        }
        return super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredItem = (PoweredItem)item;
            int color = poweredItem.getPowerBarColor(stack);
            if (color == -1) {
                return super.getBarColor(stack);
            }
            return color;
        }
        return super.getBarColor(stack);
    }
}

