/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface LeftClickableTool {
    public static Set<Ability> getCustomBindingAbilities(ItemStack stack) {
        HashSet<Ability> returnSet = new HashSet<Ability>();
        CompoundTag compoundTag = stack.getOrCreateTag();
        for (String key : compoundTag.getAllKeys()) {
            if (!key.startsWith("bindingMode_") || compoundTag.getInt(key) != 2) continue;
            String[] keyParts = key.split("_");
            String abilityName = keyParts[1];
            Ability ability = Ability.valueOf(abilityName.toUpperCase(Locale.ROOT));
            returnSet.add(ability);
        }
        return returnSet;
    }

    public static void setBindingMode(ItemStack stack, Ability ability, int mode) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        compoundTag.putInt("bindingMode_" + ability.getName(), mode);
    }

    public static int getBindingMode(ItemStack stack, Ability ability) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        return compoundTag.getInt("bindingMode_" + ability.getName());
    }

    public static void removeFromLeftClickList(ItemStack stack, Ability ability) {
        Set<Ability> abilityList = LeftClickableTool.getLeftClickList(stack);
        abilityList.remove((Object)ability);
        LeftClickableTool.setLeftClickList(stack, abilityList);
    }

    public static void addToLeftClickList(ItemStack stack, Ability ability) {
        Set<Ability> abilityList = LeftClickableTool.getLeftClickList(stack);
        abilityList.add(ability);
        LeftClickableTool.setLeftClickList(stack, abilityList);
    }

    public static void setLeftClickList(ItemStack stack, Set<Ability> abilityList) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        ListTag abilityListTag = new ListTag();
        for (Ability ability : abilityList) {
            CompoundTag comp = new CompoundTag();
            comp.putString("abilityName", ability.getName());
            abilityListTag.add((Object)comp);
        }
        compoundTag.put("leftClickAbilities", (Tag)abilityListTag);
    }

    public static Set<Ability> getLeftClickList(ItemStack stack) {
        HashSet<Ability> abilities = new HashSet<Ability>();
        CompoundTag compoundTag = stack.getOrCreateTag();
        if (compoundTag.contains("leftClickAbilities")) {
            ListTag listTag = compoundTag.getList("leftClickAbilities", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                abilities.add(Ability.valueOf(listTag.getCompound(i).getString("abilityName").toUpperCase(Locale.ROOT)));
            }
        }
        return abilities;
    }

    public static Binding getAbilityBinding(ItemStack stack, Ability ability) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        for (String key : compoundTag.getAllKeys()) {
            if (!key.startsWith("customBindingAbilities_")) continue;
            ListTag listTag = compoundTag.getList(key, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag abilityTag = listTag.getCompound(i);
                if (!abilityTag.getString("abilityName").equalsIgnoreCase(ability.getName())) continue;
                String[] keyParts = key.split("_");
                int keyCode = Integer.parseInt(keyParts[1]);
                boolean isMouse = Boolean.parseBoolean(keyParts[2]);
                return new Binding(keyCode, isMouse);
            }
        }
        return null;
    }

    public static void removeFromCustomBindingList(ItemStack stack, Ability ability) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        for (String key : compoundTag.getAllKeys()) {
            if (!key.startsWith("customBindingAbilities_")) continue;
            ListTag listTag = compoundTag.getList(key, 10);
            ListTag updatedListTag = new ListTag();
            boolean modified = false;
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag abilityTag = listTag.getCompound(i);
                if (!abilityTag.getString("abilityName").equalsIgnoreCase(ability.getName())) {
                    updatedListTag.add((Object)abilityTag);
                    continue;
                }
                modified = true;
            }
            if (!modified) continue;
            compoundTag.put(key, (Tag)updatedListTag);
        }
    }

    public static void addToCustomBindingList(ItemStack stack, Ability ability, Binding binding) {
        LeftClickableTool.removeFromCustomBindingList(stack, ability);
        Set<Ability> abilityList = LeftClickableTool.getCustomBindingList(stack, binding);
        abilityList.add(ability);
        LeftClickableTool.setCustomBindingList(stack, abilityList, binding);
    }

    public static void setCustomBindingList(ItemStack stack, Set<Ability> abilityList, Binding binding) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        ListTag abilityListTag = new ListTag();
        for (Ability ability : abilityList) {
            CompoundTag comp = new CompoundTag();
            comp.putString("abilityName", ability.getName());
            abilityListTag.add((Object)comp);
        }
        compoundTag.put("customBindingAbilities_" + binding.keyCode + "_" + binding.isMouse, (Tag)abilityListTag);
    }

    public static Set<Ability> getCustomBindingList(ItemStack stack, Binding binding) {
        HashSet<Ability> abilities = new HashSet<Ability>();
        Set<Ability> customBoundAbilities = LeftClickableTool.getCustomBindingAbilities(stack);
        CompoundTag compoundTag = stack.getOrCreateTag();
        if (compoundTag.contains("customBindingAbilities_" + binding.keyCode + "_" + binding.isMouse)) {
            ListTag listTag = compoundTag.getList("customBindingAbilities_" + binding.keyCode + "_" + binding.isMouse, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                Ability ability = Ability.valueOf(listTag.getCompound(i).getString("abilityName").toUpperCase(Locale.ROOT));
                if (!customBoundAbilities.contains((Object)ability)) continue;
                abilities.add(ability);
            }
        }
        return abilities;
    }

    public static ItemStack getLeftClickableItem(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof LeftClickableTool) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof LeftClickableTool) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }

    public static class Binding {
        public final int keyCode;
        public final boolean isMouse;

        public Binding(int keyCode, boolean isMouse) {
            this.keyCode = keyCode;
            this.isMouse = isMouse;
        }
    }
}

