/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface PoweredItem {
    default public int getAvailableEnergy(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return -1;
        }
        return energy.getEnergyStored();
    }

    default public boolean isPowerBarVisible(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return false;
        }
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    default public int getPowerBarWidth(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 13;
        }
        return Math.min(13 * energy.getEnergyStored() / energy.getMaxEnergyStored(), 13);
    }

    default public int getPowerBarColor(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return -1;
        }
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public int getMaxEnergy() {
        return 10000;
    }
}

