/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.util.NBTHelpers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ToggleableItem {
    default public boolean getEnabled(ItemStack stack) {
        return ToggleableTool.getSetting(stack, "enabled");
    }

    default public boolean setEnabled(ItemStack stack, boolean enabled) {
        return NBTHelpers.setBoolean(stack, "enabled", enabled);
    }

    default public boolean toggleEnabled(ItemStack stack) {
        return NBTHelpers.setBoolean(stack, "enabled", !this.getEnabled(stack));
    }

    public static ItemStack getToggleableItem(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof ToggleableItem) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof ToggleableItem) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }
}

