/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.blockentities.GooSoilBE;
import com.direwolf20.justdirethings.common.blocks.soil.GooSoilBase;
import com.direwolf20.justdirethings.common.containers.ToolSettingContainer;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.util.MiningCollect;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public interface ToggleableTool
extends ToggleableItem {
    public EnumSet<Ability> getAbilities();

    public Map<Ability, AbilityParams> getAbilityParamsMap();

    default public AbilityParams getAbilityParams(Ability toolAbility) {
        return this.getAbilityParamsMap().getOrDefault((Object)toolAbility, new AbilityParams(-1, -1, -1));
    }

    default public void registerAbility(Ability ability) {
        this.getAbilities().add(ability);
    }

    default public void registerAbility(Ability ability, AbilityParams abilityParams) {
        this.getAbilities().add(ability);
        this.getAbilityParamsMap().put(ability, abilityParams);
    }

    default public boolean hasAbility(Ability ability) {
        return this.getAbilities().contains((Object)ability);
    }

    default public List<Ability> getActiveAbilities(ItemStack itemStack, Ability.UseType useType) {
        ArrayList<Ability> abilityList = new ArrayList<Ability>();
        for (Ability ability : Ability.values()) {
            if (ability.useType != useType || !this.canUseAbility(itemStack, ability)) continue;
            abilityList.add(ability);
        }
        return abilityList;
    }

    default public boolean canUseAbility(ItemStack itemStack, Ability toolAbility) {
        return this.hasAbility(toolAbility) && this.getEnabled(itemStack) && ToggleableTool.getSetting(itemStack, toolAbility.getName());
    }

    default public boolean canUseAbilityAndDurability(ItemStack itemStack, Ability toolAbility) {
        return this.canUseAbility(itemStack, toolAbility) && Helpers.testUseTool(itemStack, toolAbility) >= 0;
    }

    default public boolean canUseAbilityAndDurability(ItemStack itemStack, Ability toolAbility, int multiplier) {
        return this.canUseAbility(itemStack, toolAbility) && Helpers.testUseTool(itemStack, toolAbility, multiplier) >= 0;
    }

    default public void openSettings(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ToolSettingContainer(windowId, playerInventory, player), (Component)Component.translatable((String)"")));
    }

    default public boolean hurtEnemyAbility(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Helpers.damageTool(pStack, pAttacker);
        return true;
    }

    default public Set<BlockPos> getBreakBlockPositions(ItemStack pStack, Level pLevel, BlockPos pPos, LivingEntity pEntityLiving, BlockState pState) {
        HashSet<BlockPos> breakBlockPositions = new HashSet<BlockPos>();
        if (this.canUseAbility(pStack, Ability.OREMINER) && Helpers.oreCondition.test(pState) && pStack.isCorrectToolForDrops(pState)) {
            breakBlockPositions.addAll(Helpers.findLikeBlocks(pLevel, pState, pPos, null, 64, 2));
        }
        if (this.canUseAbility(pStack, Ability.TREEFELLER) && Helpers.logCondition.test(pState) && pStack.isCorrectToolForDrops(pState)) {
            breakBlockPositions.addAll(Helpers.findLikeBlocks(pLevel, pState, pPos, null, 64, 2));
        }
        if (this.canUseAbility(pStack, Ability.HAMMER)) {
            breakBlockPositions.addAll(MiningCollect.collect(pEntityLiving, pPos, ToggleableTool.getTargetLookDirection(pEntityLiving), pLevel, ToggleableTool.getToolValue(pStack, Ability.HAMMER.getName()), MiningCollect.SizeMode.AUTO, pStack));
        }
        breakBlockPositions.add(pPos);
        if (this.canUseAbility(pStack, Ability.SKYSWEEPER) && pStack.isCorrectToolForDrops(pState)) {
            HashSet<BlockPos> newPos = new HashSet<BlockPos>();
            for (BlockPos blockPos : breakBlockPositions) {
                BlockState blockState = pLevel.getBlockState(blockPos);
                if (!Helpers.fallingBlockCondition.test(blockState)) continue;
                newPos.addAll(Helpers.findLikeBlocks(pLevel, blockState, blockPos, Direction.UP, 64, 2));
            }
            breakBlockPositions.addAll(newPos);
        }
        return breakBlockPositions;
    }

    default public boolean canInstaBreak(ItemStack pStack, Level pLevel, Set<BlockPos> breakBlockPositions) {
        boolean instaBreak = false;
        if (this.canUseAbility(pStack, Ability.INSTABREAK)) {
            float cumulativeDestroy = 0.0f;
            for (BlockPos pos : breakBlockPositions) {
                BlockState blockState = pLevel.getBlockState(pos);
                float destroySpeedTarget = blockState.getDestroySpeed((BlockGetter)pLevel, pos);
                cumulativeDestroy += destroySpeedTarget;
            }
            int rfCostInstaBreak = ToggleableTool.getInstantRFCost(cumulativeDestroy);
            if (Helpers.testUseTool(pStack, rfCostInstaBreak) > 0) {
                instaBreak = true;
            }
        }
        return instaBreak;
    }

    default public void mineBlocksAbility(ItemStack pStack, Level pLevel, BlockPos pPos, LivingEntity pEntityLiving) {
        BlockState pState = pLevel.getBlockState(pPos);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int totalExp = 0;
        int fortuneLevel = pEntityLiving.getMainHandItem().getEnchantmentLevel(Enchantments.BLOCK_FORTUNE);
        int silkTouchLevel = pEntityLiving.getMainHandItem().getEnchantmentLevel(Enchantments.SILK_TOUCH);
        Set<BlockPos> breakBlockPositions = this.getBreakBlockPositions(pStack, pLevel, pPos, pEntityLiving, pState);
        boolean instaBreak = this.canInstaBreak(pStack, pLevel, breakBlockPositions);
        for (BlockPos breakPos : breakBlockPositions) {
            if (Helpers.testUseTool(pStack) < 0) break;
            int exp = pLevel.getBlockState(breakPos).getExpDrop((LevelReader)pLevel, pLevel.random, pPos, fortuneLevel, silkTouchLevel);
            totalExp += exp;
            Helpers.combineDrops(drops, Helpers.breakBlocks(pLevel, breakPos, pEntityLiving, pStack, true, instaBreak));
        }
        if (!pLevel.isClientSide) {
            AbilityMethods.handleDrops(pStack, (ServerLevel)pLevel, pPos, pEntityLiving, breakBlockPositions, drops, pState, totalExp);
        }
    }

    public static int getInstantRFCost(float cumulativeDestroy) {
        return Math.max(Ability.INSTABREAK.getFeCost(), Ability.INSTABREAK.getFeCost() * (int)cumulativeDestroy);
    }

    public static void smelterParticles(ServerLevel level, Set<BlockPos> oreBlocksList) {
        Random random = new Random();
        int iterations = oreBlocksList.size() > 10 ? 1 : 5;
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos pos : oreBlocksList) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void smokerParticles(ServerLevel level, BlockPos itemPos, int stackSize) {
        Random random = new Random();
        int iterations = stackSize < 10 ? 1 : 5;
        for (int i = 0; i < iterations; ++i) {
            double d0 = (double)itemPos.getX() + random.nextDouble();
            double d1 = (double)itemPos.getY() + random.nextDouble();
            double d2 = (double)itemPos.getZ() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, Vec3 pos) {
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = pos.x() + random.nextDouble();
            double d1 = pos.y() - 0.5 + random.nextDouble();
            double d2 = pos.z() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, BlockPos pos, int iterations) {
        Random random = new Random();
        for (int i = 0; i < iterations; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.5 + random.nextDouble();
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void teleportParticles(ServerLevel level, Set<BlockPos> oreBlocksList) {
        int iterations = oreBlocksList.size() > 10 ? 1 : 5;
        for (BlockPos pos : oreBlocksList) {
            ToggleableTool.teleportParticles(level, pos, iterations);
        }
    }

    default public boolean useAbility(Level level, Player player, ItemStack itemStack, int keyCode, boolean isMouse) {
        boolean anyRan = false;
        HashSet<Ability> customBindAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            customBindAbilities.addAll(LeftClickableTool.getCustomBindingList(itemStack, new LeftClickableTool.Binding(keyCode, isMouse)));
        }
        for (Ability ability : this.getActiveAbilities(itemStack, Ability.UseType.USE)) {
            if (!customBindAbilities.contains((Object)ability) || ability.action == null) continue;
            ability.action.execute(level, player, itemStack);
        }
        return anyRan;
    }

    default public boolean useAbility(Level level, Player player, InteractionHand hand, boolean rightClick) {
        if (player.isShiftKeyDown()) {
            return false;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        boolean anyRan = false;
        HashSet<Ability> leftClickAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            leftClickAbilities.addAll(LeftClickableTool.getLeftClickList(itemStack));
        }
        for (Ability ability : this.getActiveAbilities(itemStack, Ability.UseType.USE)) {
            if ((!rightClick || leftClickAbilities.contains((Object)ability)) && (rightClick || !leftClickAbilities.contains((Object)ability)) || ability.action == null) continue;
            ability.action.execute(level, player, itemStack);
        }
        return anyRan;
    }

    default public boolean useOnAbility(UseOnContext pContext, ItemStack itemStack, int keyCode, boolean isMouse) {
        if (pContext.getPlayer().isShiftKeyDown()) {
            return false;
        }
        boolean anyRan = false;
        HashSet<Ability> customBindAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            customBindAbilities.addAll(LeftClickableTool.getCustomBindingList(itemStack, new LeftClickableTool.Binding(keyCode, isMouse)));
        }
        for (Ability ability : this.getActiveAbilities(itemStack, Ability.UseType.USE_ON)) {
            if (!customBindAbilities.contains((Object)ability) || ability.useOnAction == null || !ability.useOnAction.execute(pContext)) continue;
            anyRan = true;
        }
        return anyRan;
    }

    default public boolean useOnAbility(UseOnContext pContext, boolean rightClick) {
        if (pContext.getPlayer().isShiftKeyDown()) {
            return false;
        }
        ItemStack itemStack = pContext.getItemInHand();
        boolean anyRan = false;
        HashSet<Ability> leftClickAbilities = new HashSet<Ability>();
        if (itemStack.getItem() instanceof LeftClickableTool) {
            leftClickAbilities.addAll(LeftClickableTool.getLeftClickList(itemStack));
        }
        for (Ability ability : this.getActiveAbilities(itemStack, Ability.UseType.USE_ON)) {
            if ((!rightClick || leftClickAbilities.contains((Object)ability)) && (rightClick || !leftClickAbilities.contains((Object)ability)) || ability.useOnAction == null || !ability.useOnAction.execute(pContext)) continue;
            anyRan = true;
        }
        return anyRan;
    }

    default public boolean useAbility(Level level, Player player, InteractionHand hand) {
        return this.useAbility(level, player, hand, true);
    }

    default public boolean useOnAbility(UseOnContext pContext) {
        return this.useOnAbility(pContext, true);
    }

    default public boolean bindDrops(UseOnContext pContext) {
        BlockPos pPos;
        Player player = pContext.getPlayer();
        if (player == null) {
            return false;
        }
        if (!player.isShiftKeyDown()) {
            return false;
        }
        ItemStack pStack = pContext.getItemInHand();
        Item item = pStack.getItem();
        if (!(item instanceof ToggleableTool)) {
            return false;
        }
        ToggleableTool toggleableTool = (ToggleableTool)item;
        if (!toggleableTool.hasAbility(Ability.DROPTELEPORT)) {
            return false;
        }
        Level pLevel = pContext.getLevel();
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos = pContext.getClickedPos());
        if (blockEntity == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)pLevel.getCapability(Capabilities.ItemHandler.BLOCK, pPos, (Object)pContext.getClickedFace());
        if (handler == null) {
            return false;
        }
        ToggleableTool.setBoundInventory(pStack, new NBTHelpers.BoundInventory(GlobalPos.of((ResourceKey)pLevel.dimension(), (BlockPos)pPos), pContext.getClickedFace()));
        pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)pLevel.dimension().location().getPath()), "[" + pPos.toShortString() + "]"}), true);
        player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    default public boolean bindSoil(UseOnContext pContext) {
        boolean bindingSuccess = false;
        if (!pContext.getPlayer().level().isClientSide) {
            ToggleableTool toggleableTool;
            Item item;
            Level pLevel = pContext.getLevel();
            Player player = pContext.getPlayer();
            ItemStack heldItem = pContext.getItemInHand();
            BlockPos clickedPos = pContext.getClickedPos();
            BlockState blockState = pLevel.getBlockState(clickedPos);
            if (blockState.getBlock() instanceof GooSoilBase && (item = heldItem.getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbility(heldItem, Ability.DROPTELEPORT)) {
                BlockEntity blockEntity;
                NBTHelpers.BoundInventory boundInventory;
                if (Helpers.testUseTool(heldItem, Ability.DROPTELEPORT, 10) > 0 && (boundInventory = ToggleableTool.getBoundInventory(heldItem)) != null && (blockEntity = pLevel.getBlockEntity(clickedPos)) instanceof GooSoilBE) {
                    GooSoilBE gooSoilBE = (GooSoilBE)blockEntity;
                    gooSoilBE.bindInventory(boundInventory);
                    pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.boundto", (Object[])new Object[]{Component.translatable((String)boundInventory.globalPos().dimension().location().getPath()), "[" + boundInventory.globalPos().pos().toShortString() + "]"}), true);
                    player.playNotifySound(SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Helpers.damageTool(heldItem, (LivingEntity)player, Ability.DROPTELEPORT, 10);
                    bindingSuccess = true;
                }
                if (!bindingSuccess) {
                    pContext.getPlayer().displayClientMessage((Component)Component.translatable((String)"justdirethings.bindfailed").withStyle(ChatFormatting.RED), true);
                    player.playNotifySound(SoundEvents.ANVIL_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return bindingSuccess;
    }

    @NotNull
    public static Direction getTargetLookDirection(LivingEntity livingEntity) {
        double d;
        Vec3 playerLook = new Vec3(livingEntity.getX(), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ());
        Vec3 lookVec = livingEntity.getViewVector(1.0f);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            d = player.getBlockReach();
        } else {
            d = 1.0;
        }
        double reach = d;
        Vec3 endLook = playerLook.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        BlockHitResult hitResult = livingEntity.level().clip(new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity));
        return hitResult.getDirection().getOpposite();
    }

    public static ItemStack getToggleableTool(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof ToggleableTool) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof ToggleableTool) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }

    public static boolean toggleSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        tagCompound.putBoolean(setting, !ToggleableTool.getSetting(stack, setting));
        return tagCompound.getBoolean(setting);
    }

    public static boolean cycleSetting(ItemStack stack, String setting) {
        Ability toolAbility = Ability.valueOf(setting.toUpperCase(Locale.ROOT));
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        CompoundTag tagCompound = stack.getOrCreateTag();
        int currentValue = ToggleableTool.getToolValue(stack, setting);
        int nextValue = Math.min(abilityParams.maxSlider, currentValue + abilityParams.increment);
        if (nextValue == currentValue && ToggleableTool.getSetting(stack, setting)) {
            ToggleableTool.setSetting(stack, setting, false);
            nextValue = abilityParams.minSlider;
        } else if (currentValue == abilityParams.minSlider && !ToggleableTool.getSetting(stack, setting)) {
            nextValue = abilityParams.minSlider;
            ToggleableTool.setSetting(stack, setting, true);
        }
        ToggleableTool.setToolValue(stack, setting, nextValue);
        return tagCompound.getBoolean(setting);
    }

    public static void setBoundInventory(ItemStack stack, NBTHelpers.BoundInventory boundInventory) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        tagCompound.put("boundinventory", (Tag)NBTHelpers.BoundInventory.toNBT(boundInventory));
    }

    public static NBTHelpers.BoundInventory getBoundInventory(ItemStack stack) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        if (tagCompound.contains("boundinventory")) {
            return NBTHelpers.BoundInventory.fromNBT(tagCompound.getCompound("boundinventory"));
        }
        return null;
    }

    public static IItemHandler getBoundHandler(ServerLevel serverLevel, ItemStack stack) {
        NBTHelpers.BoundInventory boundInventory = ToggleableTool.getBoundInventory(stack);
        if (boundInventory != null) {
            return MiscHelpers.getAttachedInventory((Level)serverLevel.getServer().getLevel(boundInventory.globalPos().dimension()), boundInventory.globalPos().pos(), boundInventory.direction());
        }
        return null;
    }

    public static boolean setSetting(ItemStack stack, String setting, boolean value) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        tagCompound.putBoolean(setting, value);
        return tagCompound.getBoolean(setting);
    }

    public static boolean getSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        return !tagCompound.contains(setting) || tagCompound.getBoolean(setting);
    }

    @Override
    default public boolean getEnabled(ItemStack stack) {
        return ToggleableTool.getSetting(stack, "enabled");
    }

    public static void setToolValue(ItemStack stack, String valueName, int value) {
        Ability toolAbility = Ability.valueOf(valueName.toUpperCase(Locale.ROOT));
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int min = abilityParams.minSlider;
        int max = abilityParams.maxSlider;
        int setValue = Math.max(min, Math.min(max, value));
        stack.getOrCreateTag().putInt(valueName + "_value", setValue);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        Ability toolAbility = Ability.valueOf(valueName.toUpperCase(Locale.ROOT));
        AbilityParams abilityParams = ((ToggleableTool)stack.getItem()).getAbilityParams(toolAbility);
        int min = abilityParams.minSlider;
        int max = abilityParams.maxSlider;
        if (stack.getOrCreateTag().contains(valueName + "_value")) {
            return Math.max(min, Math.min(max, stack.getOrCreateTag().getInt(valueName + "_value")));
        }
        return abilityParams.defaultValue;
    }
}

