/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.tools;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.tools.basetools.BasePickaxe;
import com.direwolf20.justdirethings.common.items.tools.utils.GooTier;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.ToolActions;

public class EclipseAlloyPaxel
extends BasePickaxe
implements PoweredTool {
    public EclipseAlloyPaxel() {
        super(GooTier.ECLIPSEALLOY, 1, -2.8f, new Item.Properties().fireResistant());
        this.registerAbility(Ability.OREXRAY);
        this.registerAbility(Ability.OREMINER);
        this.registerAbility(Ability.SKYSWEEPER);
        this.registerAbility(Ability.LAWNMOWER);
        this.registerAbility(Ability.TREEFELLER);
        this.registerAbility(Ability.LEAFBREAKER);
        this.registerAbility(Ability.SMELTER);
        this.registerAbility(Ability.HAMMER, new AbilityParams(3, 7, 2));
        this.registerAbility(Ability.DROPTELEPORT);
        this.registerAbility(Ability.INSTABREAK);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isPowerBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getPowerBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        int color = this.getPowerBarColor(stack);
        if (color == -1) {
            return super.getBarColor(stack);
        }
        return color;
    }

    @Override
    public int getMaxEnergy() {
        return 500000;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return (state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL) || state.is(BlockTags.MINEABLE_WITH_AXE)) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(), (BlockState)state);
    }

    public float getDestroySpeed(ItemStack pStack, BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL) || state.is(BlockTags.MINEABLE_WITH_AXE) ? this.speed : 1.0f;
    }
}

