/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.tools.basetools;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BaseHoe
extends HoeItem
implements ToggleableTool,
LeftClickableTool {
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);

    public BaseHoe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (this.bindDrops(pContext)) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(pContext);
        this.bindSoil(pContext);
        this.useOnAbility(pContext);
        return interactionResult;
    }

    public boolean mineBlock(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        return true;
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        return this.hurtEnemyAbility(pStack, pTarget, pAttacker);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, level, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        TooltipHelpers.appendFEText(stack, tooltip);
        if (sneakPressed) {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendAbilityList(stack, tooltip);
        } else {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendShiftForInfo(stack, tooltip);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        Item item = stack.getItem();
        if (!(item instanceof PoweredTool)) {
            return modifiers;
        }
        PoweredTool poweredTool = (PoweredTool)item;
        return poweredTool.getPoweredAttributeModifiers(slot, stack, (Multimap<Attribute, AttributeModifier>)modifiers);
    }

    @Override
    public EnumSet<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown()) {
            this.openSettings(player);
        }
        this.useAbility(level, player, hand);
        return super.use(level, player, hand);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return amount;
            }
            int unbreakingLevel = stack.getEnchantmentLevel(Enchantments.UNBREAKING);
            double reductionFactor = Math.min(1.0, (double)unbreakingLevel * 0.1);
            int finalEnergyCost = (int)Math.max(0.0, (double)amount - (double)amount * reductionFactor);
            energyStorage.extractEnergy(finalEnergyCost, false);
            return 0;
        }
        return amount;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (stack.getItem() instanceof PoweredTool) {
            return super.isBookEnchantable(stack, book) && this.canAcceptEnchantments(book);
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.getItem() instanceof PoweredTool) {
            return super.canApplyAtEnchantingTable(stack, enchantment) && this.canAcceptEnchantments(enchantment);
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private boolean canAcceptEnchantments(ItemStack book) {
        return !EnchantmentHelper.getEnchantments((ItemStack)book).containsKey(Enchantments.MENDING);
    }

    private boolean canAcceptEnchantments(Enchantment enchantment) {
        return enchantment != Enchantments.MENDING;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

